/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells;

import com.robertx22.mine_and_slash.database.IGUID;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.PreCalcSpellConfigs;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ITooltipList;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.AbilityPlace;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Masteries;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public interface IAbility
extends IGUID,
ITooltipList {
    public static List<IAbility> getAll() {
        ArrayList<IAbility> list = new ArrayList<IAbility>();
        list.addAll(SlashRegistry.Synergies().getList());
        list.addAll(SlashRegistry.Spells().getList());
        list.addAll(SlashRegistry.PotionEffects().getList());
        return list;
    }

    public Elements getElement();

    public static IAbility fromId(String id) {
        IAbility ability = null;
        if (SlashRegistry.Synergies().isRegistered(id)) {
            ability = SlashRegistry.Synergies().get(id);
        } else if (SlashRegistry.Spells().isRegistered(id)) {
            ability = SlashRegistry.Spells().get(id);
        } else if (SlashRegistry.PotionEffects().isRegistered(id)) {
            ability = SlashRegistry.PotionEffects().get(id);
        }
        return ability;
    }

    public ITextComponent getLocName();

    default public int getEffectiveAbilityLevel(PlayerSpellCap.ISpellsCap spells, EntityCap.UnitData data) {
        return MathHelper.func_76125_a((int)this.getMastery().getEffectiveLevel(spells), (int)0, (int)data.getLevel());
    }

    public PreCalcSpellConfigs getPreCalcConfig();

    public ResourceLocation getIconLoc();

    public Type getAbilityType();

    default public float getLevelPowerMulti(PlayerSpellCap.ISpellsCap cap) {
        return (float)cap.getLevelOf(this) / (float)this.getMaxSpellLevelBuffed();
    }

    public int getMaxSpellLevelNormal();

    public int getMaxSpellLevelBuffed();

    public AbilityPlace getAbilityPlace();

    @Nullable
    public BaseSpell getSpell();

    @Nullable
    public IAbility getRequiredAbility();

    public Masteries getMastery();

    default public int getSchoolPointsNeeded() {
        AbilityPlace place = this.getAbilityPlace();
        if (place == null) {
            if (this.getAbilityType().equals((Object)Type.EFFECT)) {
                return 10;
            }
            throw new RuntimeException("Only effects are allowed to have null ability place, not: " + this.GUID());
        }
        if (place.y == 0) {
            return 1;
        }
        if (place.y == 1) {
            return 5;
        }
        if (place.y == 2) {
            return 10;
        }
        if (place.y == 3) {
            return 20;
        }
        if (place.y == 4) {
            return 30;
        }
        if (place.y == 5) {
            return 40;
        }
        if (place.y == 6) {
            return Masteries.MAXIMUM_POINTS;
        }
        return Integer.MAX_VALUE;
    }

    default public void finishTooltip(List<ITextComponent> list, SpellCastContext ctx, TooltipInfo info) {
        try {
            TooltipUtils.addEmpty(list);
            TooltipUtils.abilityLevel(list, ctx.spellsCap.getLevelOf(this), this.getMaxSpellLevelNormal());
            list.add((ITextComponent)new SText(TextFormatting.YELLOW + "Effective Ability level: " + this.getEffectiveAbilityLevel(ctx.spellsCap, ctx.data)));
            list.add((ITextComponent)new SText(this.getElement().format + "Element: " + this.getElement().name()));
            if (ctx.spellsCap.getAbilitiesData().getSchoolPoints(this.getMastery()) < this.getSchoolPointsNeeded()) {
                list.add(new SText(TextFormatting.RED + "Needs ").func_150257_a(this.getMastery().getFullName().func_150258_a(" of Level: " + this.getSchoolPointsNeeded())));
            }
            list.add((ITextComponent)new SText(""));
            if (!Screen.hasShiftDown()) {
                list.add(new SText(TextFormatting.BLUE + "").func_150257_a(Words.Press_Shift_For_More_Info.locName()));
            } else {
                list.add(new SText(TextFormatting.LIGHT_PURPLE + "" + TextFormatting.BOLD).func_150258_a("Ability Stats:"));
                list.addAll(ctx.getConfigFor(this).GetTooltipString(info, ctx));
                if (this instanceof Synergy) {
                    Synergy s = (Synergy)this;
                    list.add((ITextComponent)new SText(""));
                    list.add((ITextComponent)new SText(TextFormatting.LIGHT_PURPLE + "" + TextFormatting.BOLD + "Affects Spell: "));
                    list.addAll(s.getConfigsAffectingSpell().GetTooltipString(info, ctx));
                }
            }
            TooltipUtils.removeDoubleBlankLines(list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Type {
        SPELL,
        SYNERGY,
        EFFECT;

    }
}

