/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.configs.SC;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellData;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;

@Storable
public class SpellCastingData {
    @Store
    public int castingTicksLeft = 0;
    @Store
    public int castingTicksDone = 0;
    @Store
    public int lastSpellCastTimeInTicks = 0;
    @Store
    public String spellBeingCast = "";
    @Store
    private HashMap<Integer, String> firstHotbar = new HashMap();
    @Store
    private HashMap<Integer, String> secondHotbar = new HashMap();
    @Store
    private HashMap<String, SpellData> spellDatas = new HashMap();
    public static AttributeModifier CASTING_SPEED_DEBUFF = new AttributeModifier(UUID.fromString("d6d3dc82-9787-4722-9a33-924b94490e2a"), SharedMonsterAttributes.field_111263_d.func_111108_a(), (double)-0.33f, AttributeModifier.Operation.MULTIPLY_BASE);

    public void cancelCast(PlayerEntity player) {
        try {
            SpellCastContext ctx = new SpellCastContext((LivingEntity)player, 0, this.getSpellBeingCast());
            BaseSpell spell = this.getSpellBeingCast();
            if (spell != null && spell.goesOnCooldownIfCastCanceled()) {
                SpellData data = this.spellDatas.getOrDefault(spell.GUID(), new SpellData());
                int cd = spell.getCooldownInTicks(ctx);
                data.setCooldown(cd);
            }
            this.spellBeingCast = "";
            this.castingTicksLeft = 0;
            this.lastSpellCastTimeInTicks = 0;
            this.castingTicksDone = 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.getMap(Hotbar.FIRST).clear();
        this.getMap(Hotbar.SECOND).clear();
    }

    public boolean isCasting() {
        return this.castingTicksLeft > 0 && SlashRegistry.Spells().isRegistered(this.spellBeingCast);
    }

    public void onTimePass(PlayerEntity player, PlayerSpellCap.ISpellsCap spells, int ticks) {
        try {
            BaseSpell spell = SlashRegistry.Spells().get(this.spellBeingCast);
            SpellCastContext ctx = new SpellCastContext((LivingEntity)player, this.castingTicksDone, spell);
            if (!player.field_70170_p.field_72995_K) {
                if (spell != null && spells != null && SlashRegistry.Spells().isRegistered(spell)) {
                    spell.onCastingTick(ctx);
                    this.addCastingMoveDebuff(player);
                } else {
                    this.removeCastingMoveDebuff(player);
                }
            }
            this.tryCast(player, spells, ctx);
            --this.castingTicksLeft;
            ++this.castingTicksDone;
            if (!(player.field_70170_p.field_72995_K || spell != null && SlashRegistry.Spells().isRegistered(spell))) {
                this.removeCastingMoveDebuff(player);
            }
            this.spellDatas.values().forEach(x -> x.tickCooldown(ticks));
            if (this.castingTicksLeft < 0) {
                this.spellBeingCast = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addCastingMoveDebuff(PlayerEntity player) {
        IAttributeInstance atri = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (!atri.func_180374_a(CASTING_SPEED_DEBUFF)) {
            atri.func_111121_a(CASTING_SPEED_DEBUFF);
        }
    }

    public void removeCastingMoveDebuff(PlayerEntity player) {
        IAttributeInstance atri = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (atri.func_180374_a(CASTING_SPEED_DEBUFF)) {
            atri.func_111124_b(CASTING_SPEED_DEBUFF);
        }
    }

    public List<String> getSpellsOnCooldown() {
        return this.spellDatas.entrySet().stream().filter(x -> !((SpellData)x.getValue()).cooldownIsReady()).map(x -> (String)x.getKey()).collect(Collectors.toList());
    }

    public void setToCast(int key, Hotbar hotbar, PlayerEntity player, int ticks) {
        BaseSpell spell = this.getSpellByKeybind(key, hotbar);
        SpellCastContext ctx = new SpellCastContext((LivingEntity)player, 0, spell);
        this.spellBeingCast = spell.GUID();
        this.castingTicksLeft = spell.useTimeTicks(ctx);
        this.lastSpellCastTimeInTicks = spell.useTimeTicks(ctx);
        this.castingTicksDone = 0;
    }

    public void setToCast(BaseSpell spell, PlayerEntity player) {
        SpellCastContext ctx = new SpellCastContext((LivingEntity)player, 0, spell);
        this.spellBeingCast = spell.GUID();
        this.castingTicksLeft = spell.useTimeTicks(ctx);
        this.lastSpellCastTimeInTicks = spell.useTimeTicks(ctx);
        this.castingTicksDone = 0;
    }

    private void tryCast(PlayerEntity player, PlayerSpellCap.ISpellsCap spells, SpellCastContext ctx) {
        if (!this.spellBeingCast.isEmpty() && this.castingTicksLeft <= 0) {
            BaseSpell spell = SlashRegistry.Spells().get(this.spellBeingCast);
            if (spells.getAbilitiesData().getAllocatedSpells().contains(spell)) {
                int timesToCast = (int)ctx.getConfigFor(spell).get(SC.TIMES_TO_CAST).get(ctx.spellsCap, (IAbility)spell);
                if (timesToCast == 1) {
                    spell.cast(ctx);
                }
                this.onSpellCast(spell, player, spells);
                this.spellBeingCast = "";
            } else {
                this.firstHotbar.entrySet().removeIf(x -> ((String)x.getValue()).equals(spell.GUID()));
                this.secondHotbar.entrySet().removeIf(x -> ((String)x.getValue()).equals(spell.GUID()));
            }
        }
    }

    public void setHotbar(int number, Hotbar hotbar, String spellID) {
        if (!spellID.isEmpty() && !SlashRegistry.Spells().isRegistered(spellID)) {
            try {
                throw new Exception("Trying to setup spell that isn't registered!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getMap(hotbar).put(number, spellID);
    }

    public BaseSpell getSpellBeingCast() {
        return SlashRegistry.Spells().get(this.spellBeingCast);
    }

    public boolean canCast(BaseSpell spell, PlayerEntity player) {
        if (this.isCasting()) {
            return false;
        }
        if (spell == null) {
            return false;
        }
        SpellData data = this.getDataBySpell(spell);
        if (!data.cooldownIsReady()) {
            return false;
        }
        SpellCastContext ctx = new SpellCastContext((LivingEntity)player, 0, spell);
        return spell.canCast(ctx);
    }

    public boolean canCast(int key, Hotbar hotbar, PlayerEntity player) {
        if (this.isCasting()) {
            return false;
        }
        BaseSpell spell = this.getSpellByKeybind(key, hotbar);
        if (spell == null) {
            return false;
        }
        SpellData data = this.getDataBySpell(spell);
        if (!data.cooldownIsReady()) {
            return false;
        }
        SpellCastContext ctx = new SpellCastContext((LivingEntity)player, 0, spell);
        return spell.canCast(ctx);
    }

    private void onSpellCast(BaseSpell spell, PlayerEntity player, PlayerSpellCap.ISpellsCap spells) {
        SpellData data = this.spellDatas.getOrDefault(spell.GUID(), new SpellData());
        SpellCastContext ctx = new SpellCastContext((LivingEntity)player, 0, spell);
        if (spell.shouldActivateCooldown(player, spells)) {
            int cd = spell.getCooldownInTicks(ctx);
            data.setCooldown(cd);
        }
        this.spellDatas.put(spell.GUID(), data);
    }

    public HashMap<Integer, String> getMap(Hotbar hotbar) {
        if (hotbar == Hotbar.FIRST) {
            return this.firstHotbar;
        }
        return this.secondHotbar;
    }

    public SpellData getDataBySpell(BaseSpell spell) {
        String id = spell.GUID();
        if (!this.spellDatas.containsKey(id)) {
            this.spellDatas.put(id, new SpellData());
        }
        return this.spellDatas.get(id);
    }

    public SpellData getDataByKeybind(int key, Hotbar hotbar) {
        String id = this.getMap(hotbar).get(key);
        if (!this.spellDatas.containsKey(id)) {
            this.spellDatas.put(id, new SpellData());
        }
        return this.spellDatas.get(id);
    }

    @Nullable
    public BaseSpell getSpellByKeybind(int key, Hotbar hotbar) {
        String id = this.getMap(hotbar).get(key);
        if (SlashRegistry.Spells().isRegistered(id)) {
            return SlashRegistry.Spells().get(id);
        }
        return null;
    }

    public static enum Hotbar {
        FIRST,
        SECOND;

    }
}

