/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells.calc;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.calc.BaseStatCalc;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import info.loenwind.autosave.annotations.Factory;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.List;
import net.minecraft.util.text.ITextComponent;

@Storable
public class ScalingStatCalc
extends BaseStatCalc {
    @Store
    public String statID;
    @Store
    public float multi;

    public Stat getStat() {
        return SlashRegistry.Stats().get(this.statID);
    }

    @Factory
    private ScalingStatCalc() {
    }

    public ScalingStatCalc(Stat stat, float multi) {
        this.statID = stat.GUID();
        this.multi = multi;
    }

    @Override
    public float getMulti() {
        return this.multi;
    }

    public int getMultiAsPercent() {
        return (int)(this.multi * 100.0f);
    }

    @Override
    public int getCalculatedValue(EntityCap.UnitData data) {
        return (int)(data.getUnit().peekAtStat(this.statID).getAverageValue() * this.multi);
    }

    @Override
    public List<ITextComponent> GetTooltipString(TooltipInfo info) {
        return this.getTooltipFor(this.multi, this.getCalculatedValue(info.unitdata), this.getStat().locName(), this.getStat().getElement());
    }
}

