/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.spells.calc;

import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.SpellCastContext;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalAttackDamage;
import com.robertx22.mine_and_slash.database.stats.types.offense.PhysicalDamage;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.database.stats.types.resources.Health;
import com.robertx22.mine_and_slash.database.stats.types.resources.Mana;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.saveclasses.spells.StatScaling;
import com.robertx22.mine_and_slash.saveclasses.spells.calc.BaseStatCalc;
import com.robertx22.mine_and_slash.saveclasses.spells.calc.MergedScalingStatsCalc;
import com.robertx22.mine_and_slash.saveclasses.spells.calc.ScalingStatCalc;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import info.loenwind.autosave.annotations.Factory;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

@Storable
public class SpellCalcData {
    @Store
    public List<ScalingStatCalc> scalingValues = new ArrayList<ScalingStatCalc>();
    @Store
    public List<MergedScalingStatsCalc> mergedScalingValues = new ArrayList<MergedScalingStatsCalc>();
    @Store
    public StatScaling baseScaling = StatScaling.NORMAL;
    private boolean empty = false;
    @Store
    public float baseValue = 0.0f;

    public static SpellCalcData empty() {
        SpellCalcData d = new SpellCalcData();
        d.empty = true;
        return d;
    }

    public static SpellCalcData base(float base) {
        SpellCalcData data = new SpellCalcData();
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        List<Stat> list = new ElementalAttackDamage(Elements.Nature).generateAllSingleVariations();
        list.add(PhysicalDamage.getInstance());
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.GOLD + "All Attack Damage")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithElementalAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        List<Stat> list = new ElementalAttackDamage(Elements.Nature).generateAllSingleVariations();
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.GOLD + "Elemental Attack Damage")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithPhysicalAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        ArrayList<Stat> list = new ArrayList<Stat>();
        list.add(PhysicalDamage.getInstance());
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.GOLD + "Physical Attack Damage")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithFireAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        ArrayList<Stat> list = new ArrayList<Stat>();
        list.add(new ElementalAttackDamage(Elements.Fire));
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.RED + "Fire Attack Damage")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithWaterAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        ArrayList<Stat> list = new ArrayList<Stat>();
        list.add(new ElementalAttackDamage(Elements.Water));
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.AQUA + "Water Attack Damage")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithThunderAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        ArrayList<Stat> list = new ArrayList<Stat>();
        list.add(new ElementalAttackDamage(Elements.Thunder));
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.YELLOW + "Thunder Attack Damage")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithNatureAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        ArrayList<Stat> list = new ArrayList<Stat>();
        list.add(new ElementalAttackDamage(Elements.Nature));
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.DARK_GREEN + "Nature Attack Damage")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithArmorAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        ArrayList<Stat> list = new ArrayList<Stat>();
        list.add(Armor.getInstance());
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.GOLD + "Armor")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithHealthAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        ArrayList<Stat> list = new ArrayList<Stat>();
        list.add(Health.getInstance());
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.RED + "Health")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithEnergyAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        ArrayList<Stat> list = new ArrayList<Stat>();
        list.add(Energy.getInstance());
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.GREEN + "Energy")));
        data.baseValue = base;
        return data;
    }

    public static SpellCalcData scaleWithManaAttack(float attack, float base) {
        SpellCalcData data = new SpellCalcData();
        ArrayList<Stat> list = new ArrayList<Stat>();
        list.add(Mana.getInstance());
        data.mergedScalingValues.add(new MergedScalingStatsCalc(list, attack, (ITextComponent)new SText(TextFormatting.BLUE + "Mana")));
        data.baseValue = base;
        return data;
    }

    @Factory
    private SpellCalcData() {
    }

    public SpellCalcData(ScalingStatCalc calc, int base) {
        this.scalingValues.add(calc);
        this.baseValue = base;
    }

    public double getScalingMultiAverage() {
        return this.getAllScalingValues().stream().mapToDouble(x -> x.getMulti()).sum() / (double)this.scalingValues.size();
    }

    public List<BaseStatCalc> getAllScalingValues() {
        ArrayList<BaseStatCalc> list = new ArrayList<BaseStatCalc>();
        list.addAll(this.scalingValues);
        list.addAll(this.mergedScalingValues);
        return list;
    }

    public int getCalculatedBaseValue(PlayerSpellCap.ISpellsCap spells, IAbility ability, EntityCap.UnitData data) {
        return (int)this.baseScaling.scale(this.baseValue, ability.getEffectiveAbilityLevel(spells, data));
    }

    private int getCalculatedScalingValue(EntityCap.UnitData data) {
        return this.getAllScalingValues().stream().mapToInt(x -> x.getCalculatedValue(data)).sum();
    }

    public int getCalculatedValue(EntityCap.UnitData data, PlayerSpellCap.ISpellsCap spells, IAbility ability) {
        int val = this.getCalculatedScalingValue(data);
        return val += this.getCalculatedBaseValue(spells, ability, data);
    }

    public List<ITextComponent> GetTooltipString(TooltipInfo info, SpellCastContext ctx) {
        return this.GetTooltipString(info, ctx.spellsCap, ctx.ability);
    }

    public List<ITextComponent> GetTooltipString(TooltipInfo info, PlayerSpellCap.ISpellsCap spells, IAbility ability) {
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        if (!this.empty) {
            this.getAllScalingValues().forEach(x -> list.addAll(x.GetTooltipString(info)));
            if (this.baseValue > 0.0f) {
                list.add((ITextComponent)new StringTextComponent(TextFormatting.RED + "Base Value: " + this.getCalculatedBaseValue(spells, ability, info.unitdata)));
            }
        }
        return list;
    }
}

