/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.talents;

import com.robertx22.mine_and_slash.database.talent_tree.BasePerk;
import com.robertx22.mine_and_slash.registry.SlashRegistryContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IApplyableStats;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@Storable
public abstract class BasePerksData<T extends BasePerk>
implements IApplyableStats {
    @Store
    public int resetPoints = 0;
    @Store
    protected HashMap<String, Boolean> map = new HashMap();

    public boolean isAllocated(String guid) {
        return this.map.getOrDefault(guid, false);
    }

    public boolean isAllocated(T point) {
        return this.isAllocated(((BasePerk)point).GUID());
    }

    public void allocate(String guid) {
        this.map.put(guid, true);
    }

    public void remove(String guid) {
        this.map.put(guid, false);
    }

    public void reset() {
        this.map.clear();
    }

    public abstract SlashRegistryContainer getRegistryContainer();

    public int getAllocatedPerks() {
        int talents = 0;
        for (Map.Entry<String, Boolean> entry : this.map.entrySet()) {
            if (!entry.getValue().booleanValue() || !this.getRegistryContainer().isRegistered(entry.getKey())) continue;
            ++talents;
        }
        return talents;
    }

    @Override
    public void applyStats(EntityCap.UnitData data, int level) {
        for (BasePerk talent : this.getAllCurrentPerks()) {
            if (talent.effect == null || !(talent.effect instanceof IApplyableStats)) continue;
            IApplyableStats apply = (IApplyableStats)((Object)talent.effect);
            apply.applyStats(data, level);
        }
    }

    public boolean canRemove(T toRemove) {
        if (!this.isAllocated(toRemove)) {
            return false;
        }
        if (this.resetPoints <= 0) {
            return false;
        }
        int amount = this.getAllocatedPerks();
        if (amount == 2 && !((BasePerk)toRemove).isStart) {
            return true;
        }
        if (amount == 1 && ((BasePerk)toRemove).isStart) {
            return true;
        }
        for (Object obj : ((BasePerk)toRemove).connections) {
            BasePerk perk = (BasePerk)obj;
            if (!this.isAllocated(perk) || this.hasPathToStart(perk, toRemove)) continue;
            return false;
        }
        return true;
    }

    private boolean hasPathToStart(T check, T toRemove) {
        ArrayDeque openSet = new ArrayDeque();
        openSet.addAll(((BasePerk)check).connections);
        HashSet<BasePerk> closedSet = new HashSet<BasePerk>();
        while (!openSet.isEmpty()) {
            BasePerk current = (BasePerk)openSet.poll();
            if (current == toRemove || !this.isAllocated(current)) continue;
            if (current.isStart) {
                return true;
            }
            if (!closedSet.add(current)) continue;
            openSet.addAll(current.connections);
        }
        return false;
    }

    public List<T> getAllCurrentPerks() {
        ArrayList<BasePerk> list = new ArrayList<BasePerk>();
        for (Map.Entry<String, Boolean> entry : this.map.entrySet()) {
            BasePerk perk;
            if (!entry.getValue().booleanValue() || (perk = (BasePerk)this.getRegistryContainer().get(entry.getKey())) == null) continue;
            list.add(perk);
        }
        return list;
    }
}

