/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability.bases;

import com.robertx22.mine_and_slash.database.talent_tree.BasePerk;
import com.robertx22.mine_and_slash.database.talent_tree.Perk;
import com.robertx22.mine_and_slash.database.talent_tree.PerkConnection;
import com.robertx22.mine_and_slash.registry.SlashRegistryContainer;
import com.robertx22.mine_and_slash.saveclasses.talents.BasePerksData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;

public abstract class IPerkCap<T extends BasePerk, D extends BasePerksData<T>> {
    public abstract int getAllowedPoints(EntityCap.UnitData var1);

    public abstract void allocate(T var1);

    public abstract void applyStats(EntityCap.UnitData var1, PlayerEntity var2);

    public abstract D getAbilitiesData();

    public abstract SlashRegistryContainer getContainer();

    public Set<PerkConnection> getConnections() {
        HashSet<PerkConnection> set = new HashSet<PerkConnection>();
        for (Object o : this.getContainer().getList()) {
            BasePerk con;
            BasePerk talent = (BasePerk)o;
            if (((BasePerksData)this.getAbilitiesData()).isAllocated((BasePerk)talent)) {
                for (Object obj : talent.connections) {
                    con = (BasePerk)obj;
                    if (((BasePerksData)this.getAbilitiesData()).isAllocated((BasePerk)con)) {
                        set.add(new PerkConnection(PerkConnection.Allocation.ALLOCATED, talent, con));
                        continue;
                    }
                    set.add(new PerkConnection(PerkConnection.Allocation.CAN_ALLOCATE, talent, con));
                }
                continue;
            }
            for (Object obj : talent.connections) {
                con = (BasePerk)obj;
                if (((BasePerksData)this.getAbilitiesData()).isAllocated((BasePerk)con)) {
                    set.add(new PerkConnection(PerkConnection.Allocation.CAN_ALLOCATE, talent, con));
                    continue;
                }
                set.add(new PerkConnection(PerkConnection.Allocation.CANT_ALLOCATE, talent, con));
            }
        }
        return set;
    }

    public boolean hasPerk(T perk) {
        return ((BasePerksData)this.getAbilitiesData()).isAllocated(perk);
    }

    public boolean tryRemovePoint(T perk, ServerPlayerEntity player) {
        if (((BasePerksData)this.getAbilitiesData()).canRemove(perk)) {
            ((BasePerksData)this.getAbilitiesData()).remove(((BasePerk)perk).GUID());
            --((BasePerksData)this.getAbilitiesData()).resetPoints;
            return true;
        }
        return false;
    }

    public void allocate(Perk talent) {
        ((BasePerksData)this.getAbilitiesData()).allocate(talent.GUID());
    }

    public int getFreePoints(EntityCap.UnitData data) {
        return this.getAllowedPoints(data) - this.getAllocatedPoints();
    }

    public int getAllocatedPoints() {
        return ((BasePerksData)this.getAbilitiesData()).getAllocatedPerks();
    }

    public void reset() {
        ((BasePerksData)this.getAbilitiesData()).reset();
    }

    public void addResetPoints(int amount) {
        ((BasePerksData)this.getAbilitiesData()).resetPoints += amount;
    }

    public boolean allowMultipleStarts() {
        return false;
    }

    public boolean canAllocatePoint(T talent, EntityCap.UnitData data) {
        if (!(this.getFreePoints(data) > 0)) {
            return false;
        }
        if (((BasePerk)talent).isStart) {
            if (this.allowMultipleStarts()) {
                return true;
            }
            return !((BasePerksData)this.getAbilitiesData()).getAllCurrentPerks().stream().anyMatch(x -> x.isStart);
        }
        boolean can = false;
        for (Object obj : ((BasePerk)talent).connections) {
            BasePerk con = (BasePerk)obj;
            if (!((BasePerksData)this.getAbilitiesData()).isAllocated((BasePerk)con)) continue;
            can = true;
            break;
        }
        return can;
    }
}

