/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability.entity;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.bosses.base.Boss;
import com.robertx22.mine_and_slash.database.bosses.base.BossData;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.packets.sync_cap.MobCaps;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonMobCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.base.LoadSave;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityTypeUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jline.utils.Log;

@Mod.EventBusSubscriber
public class BossCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "boss");
    public static final String LOC = "data";
    @CapabilityInject(value=IBossData.class)
    public static final Capability<IBossData> Data = null;

    public static class Storage
    extends BaseStorage<IBossData> {
    }

    public static class DefaultImpl
    implements IBossData {
        BossData data = null;
        boolean isBoss = false;
        boolean doneGenerating = false;

        @Override
        public CompoundNBT saveToNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74757_a("isBoss", this.isBoss);
            nbt.func_74757_a("doneGen", this.doneGenerating);
            if (this.data != null) {
                LoadSave.Save(this.data, nbt, BossCap.LOC);
            }
            return nbt;
        }

        @Override
        public MobCaps getCapType() {
            return MobCaps.BOSS;
        }

        @Override
        public void loadFromNBT(CompoundNBT nbt) {
            this.isBoss = nbt.func_74767_n("isBoss");
            this.doneGenerating = nbt.func_74767_n("doneGen");
            if (this.isBoss) {
                try {
                    this.data = LoadSave.Load(BossData.class, new BossData(), nbt, BossCap.LOC);
                }
                catch (Exception e) {
                    this.data = new BossData();
                    Log.error((Object[])new Object[]{"Boss Mob data is null, this shouldn't happen!"});
                    e.printStackTrace();
                }
            } else {
                this.data = null;
            }
        }

        @Override
        public boolean isBoss() {
            return this.isBoss;
        }

        @Override
        public void onMobCreation(LivingEntity en) {
            if (!this.doneGenerating && RandomUtils.roll(((Double)ModConfig.INSTANCE.Server.MOB_BOSS_CHANCE_IN_MAPS.get()).floatValue()) && WorldUtils.isMapWorldClass((IWorld)en.field_70170_p) && EntityTypeUtils.isMob((Entity)en)) {
                this.data = new BossData();
                this.data.boss = SlashRegistry.Bosses().random().GUID();
                this.isBoss = true;
                this.doneGenerating = true;
            }
        }

        @Override
        public void onHealthTreshholdTriggered(LivingEntity en, BossData.HealthTreshhold treshhold) {
            this.data.getBoss().onHealthTreshholdTriggered(en, treshhold);
        }

        @Override
        public Boss getBoss() {
            if (this.data != null) {
                return this.data.getBoss();
            }
            return null;
        }

        @Override
        public void setIsBoss(boolean b) {
            this.isBoss = b;
            if (!this.isBoss) {
                this.doneGenerating = true;
            }
        }

        @Override
        public void spawnParticle(LivingEntity en) {
            IParticleData p;
            if (this.isBoss && this.data != null && (p = this.getBoss().getParticle()) != null) {
                ClientOnly.bossParticle(en, p);
            }
        }

        @Override
        public void onHealthChanged(LivingEntity en, IBossData x) {
            if (this.isBoss) {
                this.data.onHealthChanged(en, x);
            }
        }

        @Override
        public boolean hasSynergy(Synergy synergy) {
            return this.getBoss().hasSynergy(synergy);
        }

        @Override
        public void setBoss(Boss boss) {
            this.isBoss = true;
            this.data = new BossData();
            this.data.boss = boss.GUID();
            this.doneGenerating = true;
        }

        @Override
        public void onTick(LivingEntity en) {
            if (this.isBoss && en.func_70089_S()) {
                Boss boss = this.getBoss();
                if (boss != null) {
                    boss.onTick(en);
                } else {
                    Log.error((Object[])new Object[]{"Boss is null for some reason!"});
                }
            }
        }
    }

    public static class Provider
    extends BaseProvider<IBossData> {
        @Override
        public IBossData defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<IBossData> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (EntityTypeUtils.isMob((Entity)event.getObject())) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static interface IBossData
    extends ICommonMobCap {
        public boolean isBoss();

        public void onMobCreation(LivingEntity var1);

        public void onHealthTreshholdTriggered(LivingEntity var1, BossData.HealthTreshhold var2);

        public Boss getBoss();

        public void setIsBoss(boolean var1);

        public void spawnParticle(LivingEntity var1);

        public void onHealthChanged(LivingEntity var1, IBossData var2);

        public boolean hasSynergy(Synergy var1);

        public void setBoss(Boss var1);

        public void onTick(LivingEntity var1);
    }
}

