/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability.entity;

import com.robertx22.mine_and_slash.api.MineAndSlashEvents;
import com.robertx22.mine_and_slash.config.forge.CommonConfig;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfig;
import com.robertx22.mine_and_slash.database.gearitemslots.bases.GearItemSlot;
import com.robertx22.mine_and_slash.database.mob_affixes.base.MobAffix;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.stats.types.misc.BonusExp;
import com.robertx22.mine_and_slash.database.stats.types.offense.PhysicalDamage;
import com.robertx22.mine_and_slash.database.stats.types.resources.Energy;
import com.robertx22.mine_and_slash.database.tiers.base.Tier;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.mmorpg.registers.common.CriteriaRegisters;
import com.robertx22.mine_and_slash.onevent.entity.damage.DamageEventData;
import com.robertx22.mine_and_slash.onevent.player.OnLogin;
import com.robertx22.mine_and_slash.packets.NoEnergyPacket;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.CustomExactStatsData;
import com.robertx22.mine_and_slash.saveclasses.CustomStatsData;
import com.robertx22.mine_and_slash.saveclasses.EntityDmgStatsData;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonPlayerCap;
import com.robertx22.mine_and_slash.uncommon.capability.bases.INeededForClient;
import com.robertx22.mine_and_slash.uncommon.capability.world.WorldMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.CustomExactStats;
import com.robertx22.mine_and_slash.uncommon.datasaving.CustomStats;
import com.robertx22.mine_and_slash.uncommon.datasaving.Gear;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.UnitNbt;
import com.robertx22.mine_and_slash.uncommon.datasaving.base.LoadSave;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityTypeUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "entitydata");
    @CapabilityInject(value=UnitData.class)
    public static final Capability<UnitData> Data = null;
    private static final String LEVEL = "level";
    private static final String RARITY = "rarity";
    private static final String EXP = "exp";
    private static final String UUID = "uuid";
    private static final String MOB_SAVED_ONCE = "mob_saved_once";
    private static final String SET_MOB_STATS = "set_mob_stats";
    private static final String NEWBIE_STATUS = "is_a_newbie";
    private static final String DMG_STATS = "dmg_stats";
    private static final String EQUIPS_CHANGED = "EQUIPS_CHANGED";
    private static final String TIER = "TIER";
    private static final String PREVENT_LOOT = "PREVENT_LOOT";
    private static final String SHOULD_SYNC = "SHOULD_SYNC";
    private static final String ENTITY_TYPE = "ENTITY_TYPE";
    private static final String RESOURCES_LOC = "RESOURCES_LOC";

    public static class Storage
    extends BaseStorage<UnitData> {
    }

    public static class DefaultImpl
    implements UnitData {
        Unit unit = null;
        int level = 1;
        int rarity = 0;
        EntityTypeUtils.EntityType type = EntityTypeUtils.EntityType.PLAYER;
        int exp = 0;
        boolean setMobStats = false;
        String uuid = "";
        boolean isNewbie = true;
        boolean equipsChanged = true;
        int tier = 0;
        boolean shouldSync = false;
        float lastHitCooldownStr = 1.0f;
        int lastHitTicks = 0;
        EntityDmgStatsData dmgStats = new EntityDmgStatsData();
        ResourcesData resources = new ResourcesData();
        CustomStatsData customStats = new CustomStatsData();
        CustomExactStatsData customExactStats = new CustomExactStatsData();

        @Override
        public CompoundNBT getClientNBT() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(EntityCap.LEVEL, this.level);
            nbt.func_74768_a(EntityCap.RARITY, this.rarity);
            nbt.func_74778_a(EntityCap.ENTITY_TYPE, this.type.toString());
            if (this.unit != null) {
                UnitNbt.Save(nbt, this.unit);
            }
            return nbt;
        }

        @Override
        public void setClientNBT(CompoundNBT nbt) {
            this.level = nbt.func_74762_e(EntityCap.LEVEL);
            this.rarity = nbt.func_74762_e(EntityCap.RARITY);
            try {
                String typestring = nbt.func_74779_i(EntityCap.ENTITY_TYPE);
                this.type = EntityTypeUtils.EntityType.valueOf(typestring);
            }
            catch (Exception e) {
                this.type = EntityTypeUtils.EntityType.OTHER;
            }
            this.unit = UnitNbt.Load(nbt);
            if (this.unit == null) {
                this.unit = new Unit();
            }
        }

        @Override
        public CompoundNBT saveToNBT() {
            CompoundNBT nbt = this.getClientNBT();
            nbt.func_74768_a(EntityCap.EXP, this.exp);
            nbt.func_74768_a(EntityCap.TIER, this.tier);
            nbt.func_74778_a(EntityCap.UUID, this.uuid);
            nbt.func_74757_a(EntityCap.MOB_SAVED_ONCE, true);
            nbt.func_74757_a(EntityCap.SET_MOB_STATS, this.setMobStats);
            nbt.func_74757_a(EntityCap.NEWBIE_STATUS, this.isNewbie);
            nbt.func_74757_a(EntityCap.EQUIPS_CHANGED, this.equipsChanged);
            nbt.func_74757_a(EntityCap.SHOULD_SYNC, this.shouldSync);
            nbt.func_74776_a("cdr", this.lastHitCooldownStr);
            nbt.func_74768_a("lht", this.lastHitTicks);
            if (this.customStats != null) {
                CustomStats.Save(nbt, this.customStats);
            }
            if (this.customExactStats != null) {
                CustomExactStats.Save(nbt, this.customExactStats);
            }
            if (this.resources != null) {
                LoadSave.Save(this.resources, nbt, EntityCap.RESOURCES_LOC);
            }
            if (this.dmgStats != null) {
                LoadSave.Save(this.dmgStats, nbt, EntityCap.DMG_STATS);
            }
            return nbt;
        }

        @Override
        public void loadFromNBT(CompoundNBT nbt) {
            this.setClientNBT(nbt);
            this.exp = nbt.func_74762_e(EntityCap.EXP);
            this.tier = nbt.func_74762_e(EntityCap.TIER);
            this.uuid = nbt.func_74779_i(EntityCap.UUID);
            this.setMobStats = nbt.func_74767_n(EntityCap.SET_MOB_STATS);
            this.isNewbie = nbt.func_74767_n(EntityCap.NEWBIE_STATUS);
            this.equipsChanged = nbt.func_74767_n(EntityCap.EQUIPS_CHANGED);
            this.shouldSync = nbt.func_74767_n(EntityCap.SHOULD_SYNC);
            this.lastHitCooldownStr = nbt.func_74760_g("cdr");
            this.lastHitTicks = nbt.func_74762_e("lht");
            try {
                this.resources = LoadSave.Load(ResourcesData.class, new ResourcesData(), nbt, EntityCap.RESOURCES_LOC);
                if (this.resources == null) {
                    this.resources = new ResourcesData();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.dmgStats = LoadSave.Load(EntityDmgStatsData.class, new EntityDmgStatsData(), nbt, EntityCap.DMG_STATS);
                if (this.dmgStats == null) {
                    this.dmgStats = new EntityDmgStatsData();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.customStats = CustomStats.Load(nbt);
            if (this.customStats == null) {
                this.customStats = new CustomStatsData();
            }
            this.customExactStats = CustomExactStats.Load(nbt);
            if (this.customExactStats == null) {
                this.customExactStats = new CustomExactStatsData();
            }
        }

        @Override
        public int getExpRequiredForLevelUp() {
            return DefaultImpl.levelToExp(this.getLevel() + 1);
        }

        public static void testEXPLevelingCurve() {
            int i;
            System.out.println("Old Formula");
            for (i = 1; i < 101; ++i) {
            }
            System.out.println("New Formula");
            for (i = 1; i < 101; ++i) {
                System.out.println("level: " + i + " exp: " + DefaultImpl.levelToExp(i));
            }
        }

        public static int equateXp(double lvl) {
            return (int)Math.floor(lvl + 340.0 * Math.pow(2.0, lvl / 9.0));
        }

        public static int levelToExp(int level) {
            return level * level * level * 10;
        }

        @Override
        public void SetMobLevelAtSpawn(WorldMapCap.IWorldMapData data, LivingEntity entity, PlayerEntity nearestPlayer) {
            this.setMobStats = true;
            if (WorldUtils.isMapWorldClass((IWorld)entity.field_70170_p)) {
                this.level = data.getLevel(entity.func_180425_c(), (IWorld)entity.field_70170_p);
            } else {
                this.setMobLvlNormally(entity, nearestPlayer);
            }
        }

        private void setMobLvlNormally(LivingEntity entity, PlayerEntity nearestPlayer) {
            ModEntityConfig entityConfig = SlashRegistry.getEntityConfig(entity, this);
            int lvl = LevelUtils.determineLevel(entity.field_70170_p, entity.func_180425_c(), nearestPlayer) + entityConfig.LEVEL_MODIFIER;
            this.level = MathHelper.func_76125_a((int)lvl, (int)entityConfig.MIN_LEVEL, (int)entityConfig.MAX_LEVEL);
        }

        @Override
        public void setEquipsChanged(boolean bool) {
            this.equipsChanged = bool;
        }

        @Override
        public void onDamagedBy(LivingEntity entity, float dmg, LivingEntity self) {
            try {
                this.dmgStats.onDamage(entity, dmg);
                if (entity == null && self != null) {
                    float msDamage = this.getUnit().magicShieldData().getAverageValue() * (dmg / self.func_110138_aP());
                    ResourcesData.Context ms = new ResourcesData.Context(this, self, ResourcesData.Type.MAGIC_SHIELD, msDamage, ResourcesData.Use.SPEND);
                    this.getResources().modify(ms);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public Entity getHighestDamageEntity(Entity entity) {
            return this.dmgStats.getHighestDamageEntity((ServerWorld)entity.field_70170_p);
        }

        @Override
        public int PostGiveExpEvent(LivingEntity killed, PlayerEntity player, int i) {
            i = (int)((double)i * (Double)ModConfig.INSTANCE.Server.EXPERIENCE_MULTIPLIER.get());
            i = (int)((double)i * ((double)this.getUnit().peekAtStat(BonusExp.GUID).getAverageValue() / 100.0 + 1.0));
            MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.GiveExpEvent(killed, player, this, i));
            return i;
        }

        @Override
        public int GiveExp(PlayerEntity player, int i) {
            this.setExp(this.exp + i);
            if (this.exp > this.getExpRequiredForLevelUp()) {
                if (this.CheckIfCanLevelUp() && this.CheckLevelCap()) {
                    this.LevelUp(player);
                }
                return i;
            }
            return i;
        }

        @Override
        public boolean CheckIfCanLevelUp() {
            return this.getExp() >= this.getExpRequiredForLevelUp();
        }

        public int getRemainingExp() {
            int num = this.getExp() - this.getExpRequiredForLevelUp();
            if (num < 0) {
                num = 0;
            }
            return num;
        }

        @Override
        public boolean CheckLevelCap() {
            return this.getLevel() + 1 <= (Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get();
        }

        @Override
        public boolean LevelUp(PlayerEntity player) {
            if (!this.CheckIfCanLevelUp()) {
                player.func_145747_a(Chats.Not_enough_experience.locName());
            } else if (!this.CheckLevelCap()) {
                player.func_145747_a(Chats.Can_not_go_over_maximum_level.locName());
            }
            if (this.CheckIfCanLevelUp() && this.CheckLevelCap()) {
                this.setLevel(this.level + 1, (LivingEntity)player);
                this.setExp(this.getRemainingExp());
                player.func_145747_a(new StringTextComponent(TextFormatting.YELLOW + "" + TextFormatting.BOLD).func_150257_a(Chats.You_have_leveled_up.locName()).func_150258_a("!"));
                CriteriaRegisters.PLAYER_LEVEL_TRIGGER.trigger((ServerPlayerEntity)player, this);
                this.onLvlPostMsg((LivingEntity)player);
                try {
                    Load.playersCapBackup(MapManager.getWorld(DimensionType.field_223227_a_)).getBackup().backup((ServerPlayerEntity)player, this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        public void onLvlPostMsg(LivingEntity en) {
            int stats;
            int spells;
            int talents = Load.talents((PlayerEntity)en).getFreePoints(this);
            int total = talents + (spells = Load.spells((LivingEntity)((PlayerEntity)en)).getAbilitiesData().getFreeAbilityPoints(this)) + (stats = Load.statPoints((PlayerEntity)en).getAvailablePoints(this));
            if (total > 0) {
                StringTextComponent msg = new StringTextComponent(TextFormatting.BLUE + "You have " + total + " Unspent Level up points." + TextFormatting.ITALIC + " Click to Open Main Hub [Default key: (H)]");
                msg.func_150255_a(msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/slash open hub")));
                en.func_145747_a((ITextComponent)msg);
            }
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public void setLevel(int lvl, LivingEntity entity) {
            this.level = MathHelper.func_76125_a((int)lvl, (int)1, (int)((Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get()));
            this.equipsChanged = true;
            this.shouldSync = true;
            if (entity instanceof ServerPlayerEntity) {
                CriteriaRegisters.PLAYER_LEVEL_TRIGGER.trigger((ServerPlayerEntity)entity, this);
            }
        }

        @Override
        public int getExp() {
            return this.exp;
        }

        @Override
        public void setExp(int exp) {
            this.exp = exp;
        }

        @Override
        public void onAttackEntity(LivingEntity attacker, LivingEntity victim) {
        }

        @Override
        public void modifyResource(ResourcesData.Context ctx) {
            this.resources.modify(ctx);
        }

        @Override
        public void onDeath(LivingEntity en) {
            int expLoss = (int)((double)this.exp * (Double)ModConfig.INSTANCE.Server.XP_LOSS_ON_DEATH.get());
            if (expLoss > 0) {
                this.exp = MathHelper.func_76125_a((int)(this.exp - expLoss), (int)0, (int)Integer.MAX_VALUE);
            }
        }

        @Override
        public void setType(LivingEntity en) {
            this.type = EntityTypeUtils.getType(en);
        }

        @Override
        public EntityTypeUtils.EntityType getType() {
            return this.type;
        }

        @Override
        public void trySync(LivingEntity entity) {
            if (this.shouldSync) {
                this.shouldSync = false;
                if (!Unit.shouldSendUpdatePackets(entity)) {
                    return;
                }
                MMORPG.sendToTracking(Unit.getUpdatePacketFor(entity, this), (Entity)entity);
            }
        }

        @Override
        public PlayerCaps getCapType() {
            return PlayerCaps.ENTITY_DATA;
        }

        @Override
        public Unit getUnit() {
            return this.unit;
        }

        @Override
        public void setUnit(Unit unit, LivingEntity entity) {
            this.unit = unit;
        }

        @Override
        public void setRarity(int rarity) {
            this.rarity = MathHelper.func_76125_a((int)rarity, (int)-2, (int)4);
            this.equipsChanged = true;
        }

        @Override
        public int getRarity() {
            return MathHelper.func_76125_a((int)this.rarity, (int)-2, (int)4);
        }

        @Override
        public String getUUID() {
            return this.uuid;
        }

        @Override
        public void setUUID(UUID id) {
            this.uuid = id.toString();
        }

        @Override
        public ITextComponent getName(LivingEntity entity) {
            ITextComponent finalName;
            if (entity instanceof PlayerEntity) {
                return new StringTextComponent("[Lv:").func_150258_a(this.getLevel() + "]  ").func_150257_a(entity.func_145748_c_());
            }
            MobRarity rarity = (MobRarity)Rarities.Mobs.get(this.getRarity());
            ITextComponent rarityprefix = rarity.locName();
            ITextComponent name = entity.func_145748_c_();
            MobAffix prefix = this.getUnit().getPrefix();
            MobAffix suffix = this.getUnit().getSuffix();
            ITextComponent iTextComponent = finalName = prefix == null ? name : prefix.locName().func_150258_a(" ").func_150257_a(name);
            if (suffix != null) {
                finalName.func_150258_a(" ").func_150257_a(suffix.locName());
            }
            ITextComponent lvlcomp = Styles.YELLOWCOMP().func_150257_a((ITextComponent)new StringTextComponent("[Lv:" + this.getLevel() + "] "));
            ITextComponent part = new StringTextComponent(rarity.textFormatting() + "").func_150257_a(rarityprefix.func_150258_a(" ").func_150257_a(finalName));
            ITextComponent tx = lvlcomp.func_150257_a(part);
            return tx;
        }

        @Override
        public void tryRecalculateStats(LivingEntity entity) {
            if (this.unit == null) {
                this.unit = new Unit();
            }
            if (this.needsToRecalcStats()) {
                this.unit.recalculateStats(entity, this, this.level, null);
            }
        }

        @Override
        public void forceRecalculateStats(LivingEntity entity, DamageEventData data) {
            this.unit.recalculateStats(entity, this, this.level, data);
        }

        @Override
        public void forceRecalculateStats(LivingEntity entity) {
            if (this.unit == null) {
                this.unit = new Unit();
            }
            this.unit.recalculateStats(entity, this, this.level, null);
        }

        private boolean needsToRecalcStats() {
            return this.equipsChanged;
        }

        @Override
        public void forceSetUnit(Unit unit) {
            this.unit = unit;
        }

        @Override
        public GearItemData setupWeaponData(LivingEntity entity) {
            return Gear.Load(entity.func_184614_ca());
        }

        @Override
        public int getLastHitTicksExisted() {
            return this.lastHitTicks;
        }

        @Override
        public void setAttackCooldown(PlayerEntity player) {
            this.lastHitCooldownStr = player.func_184825_o(0.5f);
            this.lastHitTicks = player.field_70173_aa;
        }

        @Override
        public float getAttackCooldown() {
            return this.lastHitCooldownStr;
        }

        @Override
        public boolean isAttackCooldownInSweepRange() {
            return this.getAttackCooldown() > 0.9f;
        }

        @Override
        public boolean tryUseWeapon(GearItemData weaponData, LivingEntity source) {
            return this.tryUseWeapon(weaponData, source, 1.0f);
        }

        @Override
        public boolean tryUseWeapon(GearItemData weaponData, LivingEntity source, float multi) {
            try {
                if (weaponData != null) {
                    GearItemSlot slot = weaponData.GetBaseGearType();
                    float energyCost = slot.getSwingCosts().GetEnergyCost(weaponData.getLevel()) * multi;
                    float manaCost = slot.getSwingCosts().GetManaCost(weaponData.getLevel()) * multi;
                    float cooldown = this.getAttackCooldown();
                    energyCost *= cooldown;
                    manaCost *= cooldown;
                    if (!this.isAttackCooldownInSweepRange()) {
                        float penalty = 1.2f;
                        energyCost *= penalty;
                        manaCost *= penalty;
                    }
                    ResourcesData.Context ene = new ResourcesData.Context(this, source, ResourcesData.Type.ENERGY, energyCost, ResourcesData.Use.SPEND);
                    ResourcesData.Context mana = new ResourcesData.Context(this, source, ResourcesData.Type.MANA, manaCost, ResourcesData.Use.SPEND);
                    if (!this.getResources().hasEnough(ene)) {
                        if (source instanceof ServerPlayerEntity) {
                            MMORPG.sendToClient(new NoEnergyPacket(), (ServerPlayerEntity)source);
                        }
                        return false;
                    }
                    if (!this.getResources().hasEnough(mana)) {
                        if (source instanceof ServerPlayerEntity) {
                            MMORPG.sendToClient(new NoEnergyPacket(), (ServerPlayerEntity)source);
                        }
                        return false;
                    }
                    this.getResources().modify(ene);
                    this.getResources().modify(mana);
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        public void onLogin(PlayerEntity player) {
            try {
                if (this.unit == null) {
                    this.unit = new Unit();
                }
                this.unit.removeUnregisteredStats();
                if (this.isNewbie()) {
                    this.setNewbieStatus(false);
                    if (((Boolean)CommonConfig.INSTANCE.GET_STARTER_ITEMS.get()).booleanValue()) {
                        OnLogin.GiveStarterItems(player);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean increaseRarity(LivingEntity entity) {
            if (this.rarity == 4) {
                return false;
            }
            ++this.rarity;
            this.shouldSync = true;
            return true;
        }

        @Override
        public boolean decreaseRarity(LivingEntity entity) {
            if (this.rarity - 1 < 0) {
                return false;
            }
            --this.rarity;
            this.shouldSync = true;
            return true;
        }

        @Override
        public boolean isWeapon(GearItemData gear) {
            try {
                if (gear == null) {
                    return false;
                }
                if (gear.GetBaseGearType().slotType().equals((Object)GearItemSlot.GearSlotType.Weapon)) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return false;
        }

        @Override
        public void setTier(int tier) {
            this.tier = tier;
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public Tier getMapTier() {
            return SlashRegistry.Tiers().get(this.tier + "");
        }

        @Override
        public CustomStatsData getCustomStats() {
            return this.customStats;
        }

        @Override
        public CustomExactStatsData getCustomExactStats() {
            return this.customExactStats;
        }

        @Override
        public ResourcesData getResources() {
            return this.resources;
        }

        @Override
        public float getCurrentEnergy() {
            return this.resources.getEnergy();
        }

        @Override
        public float getCurrentMana() {
            return this.resources.getMana();
        }

        @Override
        public int getLvlForResourceCosts() {
            return this.getLevel();
        }

        @Override
        public void attackWithWeapon(DamageEventData data) {
            if (data.weaponData.GetBaseGearType().getWeaponMechanic() != null) {
                if (data.weapon != null) {
                    data.weapon.func_96631_a(1, new Random(), null);
                }
                data.weaponData.GetBaseGearType().getWeaponMechanic().attack(data);
            }
        }

        @Override
        public void unarmedAttack(DamageEventData data) {
            float cost = ((Double)ModConfig.INSTANCE.Server.UNARMED_ENERGY_COST.get()).floatValue();
            cost = Energy.getInstance().calculateScalingStatGrowth(cost, this.getLvlForResourceCosts());
            ResourcesData.Context energy = new ResourcesData.Context(this, data.source, ResourcesData.Type.ENERGY, cost, ResourcesData.Use.SPEND);
            if (this.getResources().hasEnough(energy)) {
                this.getResources().modify(energy);
                int num = (int)this.unit.getCreateStat(PhysicalDamage.GUID).getRandomRangeValue();
                DamageEffect dmg = new DamageEffect(data, num, EffectData.EffectTypes.NORMAL, WeaponTypes.None);
                dmg.Activate();
            }
        }

        @Override
        public void mobBasicAttack(DamageEventData data) {
            MobRarity rar = (MobRarity)Rarities.Mobs.get(data.sourceData.getRarity());
            float vanilla = PhysicalDamage.getInstance().getScaling().scale(data.getEventDamage(), data.sourceData.getLevel());
            float num = vanilla * rar.DamageMultiplier() * this.getMapTier().mob_damage_multi;
            num = (float)((double)num * SlashRegistry.getEntityConfig((LivingEntity)data.source, (UnitData)data.sourceData).DMG_MULTI);
            DamageEffect dmg = new DamageEffect(data, (int)num, EffectData.EffectTypes.BASIC_ATTACK, WeaponTypes.None);
            dmg.Activate();
        }

        @Override
        public void freelySetLevel(int lvl) {
            this.level = lvl;
        }

        @Override
        public boolean isNewbie() {
            return this.isNewbie;
        }

        @Override
        public void setNewbieStatus(boolean bool) {
            this.isNewbie = bool;
        }

        @Override
        public boolean needsToBeGivenStats() {
            return !this.setMobStats;
        }
    }

    public static class Provider
    extends BaseProvider<UnitData> {
        @Override
        public UnitData defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<UnitData> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof ArmorStandEntity) {
                return;
            }
            if (event.getObject() instanceof LivingEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static interface UnitData
    extends ICommonPlayerCap,
    INeededForClient {
        public void modifyResource(ResourcesData.Context var1);

        public void onDeath(LivingEntity var1);

        public void setType(LivingEntity var1);

        public EntityTypeUtils.EntityType getType();

        public void trySync(LivingEntity var1);

        public void onAttackEntity(LivingEntity var1, LivingEntity var2);

        public GearItemData setupWeaponData(LivingEntity var1);

        public int getLastHitTicksExisted();

        public void setAttackCooldown(PlayerEntity var1);

        public float getAttackCooldown();

        public boolean isAttackCooldownInSweepRange();

        public void setEquipsChanged(boolean var1);

        public void onDamagedBy(LivingEntity var1, float var2, LivingEntity var3);

        public Entity getHighestDamageEntity(Entity var1);

        public int PostGiveExpEvent(LivingEntity var1, PlayerEntity var2, int var3);

        public boolean isNewbie();

        public void setNewbieStatus(boolean var1);

        public boolean needsToBeGivenStats();

        public void freelySetLevel(int var1);

        public int getLevel();

        public void setLevel(int var1, LivingEntity var2);

        public boolean increaseRarity(LivingEntity var1);

        public int getExp();

        public void setExp(int var1);

        public int GiveExp(PlayerEntity var1, int var2);

        public int getExpRequiredForLevelUp();

        public boolean CheckIfCanLevelUp();

        public boolean LevelUp(PlayerEntity var1);

        public boolean CheckLevelCap();

        public void SetMobLevelAtSpawn(WorldMapCap.IWorldMapData var1, LivingEntity var2, PlayerEntity var3);

        public Unit getUnit();

        public void setUnit(Unit var1, LivingEntity var2);

        public void setRarity(int var1);

        public int getRarity();

        public String getUUID();

        public void setUUID(UUID var1);

        public ITextComponent getName(LivingEntity var1);

        public void tryRecalculateStats(LivingEntity var1);

        public void forceRecalculateStats(LivingEntity var1, DamageEventData var2);

        public void forceRecalculateStats(LivingEntity var1);

        public void forceSetUnit(Unit var1);

        public boolean tryUseWeapon(GearItemData var1, LivingEntity var2);

        public boolean tryUseWeapon(GearItemData var1, LivingEntity var2, float var3);

        public void onLogin(PlayerEntity var1);

        public boolean decreaseRarity(LivingEntity var1);

        public boolean isWeapon(GearItemData var1);

        public void setTier(int var1);

        public int getTier();

        public Tier getMapTier();

        public CustomStatsData getCustomStats();

        public CustomExactStatsData getCustomExactStats();

        public ResourcesData getResources();

        public float getCurrentEnergy();

        public float getCurrentMana();

        public int getLvlForResourceCosts();

        public void attackWithWeapon(DamageEventData var1);

        public void unarmedAttack(DamageEventData var1);

        public void mobBasicAttack(DamageEventData var1);
    }
}

