/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability.player;

import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.saveclasses.PlayerWholeMapData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.uncommon.Statics;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonPlayerCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.base.LoadSave;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerMapCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "playermapdata");
    @CapabilityInject(value=IPlayerMapData.class)
    public static final Capability<IPlayerMapData> Data = null;
    static final String LOC = "mmorpgdata";

    public static class Storage
    extends BaseStorage<IPlayerMapData> {
    }

    public static class DefaultImpl
    implements IPlayerMapData {
        PlayerWholeMapData data = new PlayerWholeMapData();

        @Override
        public CompoundNBT saveToNBT() {
            CompoundNBT nbt = new CompoundNBT();
            if (this.data != null) {
                LoadSave.Save(this.data, nbt, PlayerMapCap.LOC);
            }
            return nbt;
        }

        @Override
        public void loadFromNBT(CompoundNBT nbt) {
            this.data = LoadSave.Load(PlayerWholeMapData.class, new PlayerWholeMapData(), nbt, PlayerMapCap.LOC);
            if (this.data == null) {
                this.data = new PlayerWholeMapData();
            }
        }

        @Override
        public PlayerCaps getCapType() {
            return PlayerCaps.MAP_DATA;
        }

        @Override
        public void onPlayerDeath(PlayerEntity player) {
        }

        @Override
        public boolean isPermaDeath() {
            return false;
        }

        @Override
        public void init(BlockPos pos, MapItemData map, DimensionType type, PlayerEntity player) {
            if (Statics.EMPTY_POS.equals((Object)pos)) {
                try {
                    throw new Exception("Empty pos!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.data = new PlayerWholeMapData();
            this.data.mapDevicePos = new BlockPos((Vec3i)pos).func_177984_a();
            this.data.setOriginalDimension(player.field_70170_p.func_201675_m().func_186058_p());
            this.data.mapdata = map.clone();
            this.data.questFinished = false;
            this.data.setPlayerId(player);
            this.data.isActive = true;
            MMORPG.syncMapData((ServerPlayerEntity)player);
        }

        @Override
        public void initKey(BlockPos pos, DimensionType type, PlayerEntity player, ChunkPos cpos) {
            if (Statics.EMPTY_POS.equals((Object)pos)) {
                try {
                    throw new Exception("Empty pos!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.data = new PlayerWholeMapData();
            this.data.mapDevicePos = new BlockPos((Vec3i)pos).func_177984_a();
            this.data.setOriginalDimension(player.field_70170_p.func_201675_m().func_186058_p());
            this.data.questFinished = false;
            this.data.setPlayerId(player);
            this.data.isActive = true;
            this.data.cpos = cpos.func_206849_h();
            MMORPG.syncMapData((ServerPlayerEntity)player);
        }

        @Override
        public void onQuestFinished() {
            this.data.questFinished = true;
        }

        @Override
        public void onMinute(PlayerEntity player) {
        }

        @Override
        public void onTickIfDead(ServerPlayerEntity player) {
        }

        @Override
        public float getLootMultiplier(PlayerEntity player) {
            return 1.0f;
        }

        @Override
        public boolean isMapActive() {
            return this.data != null && this.data.isActive;
        }

        @Override
        public String getLastMapGUID() {
            return this.getMap().mapUUID;
        }

        @Override
        public MapItemData getMap() {
            if (this.data != null && this.data.mapdata != null) {
                return this.data.mapdata;
            }
            return MapItemData.empty();
        }

        @Override
        public BlockPos getMapDevicePos(World world) {
            if (this.data.mapDevicePos.func_177956_o() < 3) {
                this.data.mapDevicePos = WorldUtils.getSurface((IWorld)world, this.data.mapDevicePos);
            }
            return this.data.mapDevicePos;
        }

        @Override
        public DimensionType getOriginalDimension() {
            return this.data.getOriginalDimension();
        }

        private static void error(String str) {
            System.out.println("[Mine and Slash Map Error]: " + str);
        }

        @Override
        public void teleportPlayerBack(PlayerEntity player) {
            if (WorldUtils.isMapWorldClass((IWorld)player.field_70170_p)) {
                BlockPos pos = null;
                try {
                    pos = this.getMapDevicePos(player.field_70170_p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (pos == null) {
                    DefaultImpl.error("Map device pos is null");
                    pos = player.func_180470_cg();
                    if (pos == null) {
                        DefaultImpl.error("Bed location attempt:1 is null");
                    }
                    try {
                        Optional opt = player.func_213374_dv();
                        if (opt.isPresent()) {
                            pos = (BlockPos)opt.get();
                        }
                    }
                    catch (Exception e) {
                        DefaultImpl.error("Bed location attempt:2 is null");
                    }
                }
                if (pos == null) {
                    try {
                        pos = MapManager.getWorld(DimensionType.field_223227_a_).func_175694_M();
                    }
                    catch (Exception e) {
                        DefaultImpl.error("Last safeguard failed, can't even get spawn point of overworld");
                        e.printStackTrace();
                        pos = new BlockPos(0, 90, 0);
                    }
                }
                PlayerUtils.changeDimension((ServerPlayerEntity)player, this.data.getOriginalDimension(), pos);
            }
        }
    }

    public static class Provider
    extends BaseProvider<IPlayerMapData> {
        @Override
        public IPlayerMapData defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<IPlayerMapData> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static interface IPlayerMapData
    extends ICommonPlayerCap {
        public void onTickIfDead(ServerPlayerEntity var1);

        public void initKey(BlockPos var1, DimensionType var2, PlayerEntity var3, ChunkPos var4);

        public void onMinute(PlayerEntity var1);

        public float getLootMultiplier(PlayerEntity var1);

        public boolean isMapActive();

        public String getLastMapGUID();

        public MapItemData getMap();

        public BlockPos getMapDevicePos(World var1);

        public DimensionType getOriginalDimension();

        public void teleportPlayerBack(PlayerEntity var1);

        public void onPlayerDeath(PlayerEntity var1);

        public boolean isPermaDeath();

        public void init(BlockPos var1, MapItemData var2, DimensionType var3, PlayerEntity var4);

        public void onQuestFinished();
    }
}

