/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability.player;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.BaseSpell;
import com.robertx22.mine_and_slash.database.spells.synergies.base.Synergy;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.saveclasses.spells.AllocatedAbilitiesData;
import com.robertx22.mine_and_slash.saveclasses.spells.IAbility;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonPlayerCap;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.base.LoadSave;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerSpellCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "spells");
    private static final String SPELL_PERK_DATA = "spell_perk_data";
    private static final String PLAYER_SPELL_DATA = "player_spells_data";
    @CapabilityInject(value=ISpellsCap.class)
    public static final Capability<ISpellsCap> Data = null;

    public static class Storage
    extends BaseStorage<ISpellsCap> {
    }

    public static class DefaultImpl
    extends ISpellsCap {
        AllocatedAbilitiesData abilitiesData = new AllocatedAbilitiesData();
        SpellCastingData spellCastingData = new SpellCastingData();

        public void tryRemovePoint(IAbility ability, ServerPlayerEntity player) {
            this.abilitiesData.removePoint(ability);
            this.getCastingData().clear();
            this.syncToClient((PlayerEntity)player);
        }

        @Override
        public CompoundNBT saveToNBT() {
            CompoundNBT nbt = new CompoundNBT();
            try {
                LoadSave.Save(this.abilitiesData, nbt, PlayerSpellCap.SPELL_PERK_DATA);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                LoadSave.Save(this.spellCastingData, nbt, PlayerSpellCap.PLAYER_SPELL_DATA);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return nbt;
        }

        @Override
        public PlayerCaps getCapType() {
            return PlayerCaps.SPELLS;
        }

        @Override
        public void loadFromNBT(CompoundNBT nbt) {
            this.abilitiesData = LoadSave.Load(AllocatedAbilitiesData.class, new AllocatedAbilitiesData(), nbt, PlayerSpellCap.SPELL_PERK_DATA);
            if (this.abilitiesData == null) {
                this.abilitiesData = new AllocatedAbilitiesData();
            }
            this.spellCastingData = LoadSave.Load(SpellCastingData.class, new SpellCastingData(), nbt, PlayerSpellCap.PLAYER_SPELL_DATA);
            if (this.spellCastingData == null) {
                this.spellCastingData = new SpellCastingData();
            }
        }

        @Override
        public int getAllowedPoints(EntityCap.UnitData data) {
            int perlvl = (int)((float)((Integer)ModConfig.INSTANCE.Server.SPELL_POINTS_AT_MAX_LEVEL.get()).intValue() / (float)((Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get()).intValue() * (float)data.getLevel());
            int starting = (Integer)ModConfig.INSTANCE.Server.STARTING_SPELL_POINTS.get();
            return starting + perlvl;
        }

        @Override
        public void addPoint(IAbility ability) {
            this.getAbilitiesData().addPoint(ability);
        }

        @Override
        public void applyStats(EntityCap.UnitData data, PlayerEntity player) {
            this.abilitiesData.applyStats(data);
        }

        @Override
        public AllocatedAbilitiesData getAbilitiesData() {
            return this.abilitiesData;
        }

        @Override
        public BaseSpell getSpellByKeybind(int key, SpellCastingData.Hotbar hotbar) {
            return this.spellCastingData.getSpellByKeybind(key, hotbar);
        }

        @Override
        public SpellCastingData getCastingData() {
            return this.spellCastingData;
        }

        @Override
        public boolean canCastRightClickSpell(BaseSpell spell, PlayerEntity player) {
            if (this.getAbilitiesData().getLevelOf(spell) < 1) {
                return false;
            }
            return this.getCastingData().canCast(spell, player);
        }

        @Override
        public List<BaseSpell> getAvailableSpells() {
            return this.abilitiesData.getAllocatedSpells();
        }

        @Override
        public int getLevelOf(IAbility ability) {
            return this.getAbilitiesData().getLevelOf(ability);
        }

        @Override
        public boolean hasSynergy(Synergy synergy) {
            return this.getLevelOf(synergy) > 0;
        }

        @Override
        public void reset() {
            this.getAbilitiesData().reset();
            this.getCastingData().clear();
        }
    }

    public static class Provider
    extends BaseProvider<ISpellsCap> {
        @Override
        public ISpellsCap defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<ISpellsCap> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static abstract class ISpellsCap
    implements ICommonPlayerCap {
        public abstract int getAllowedPoints(EntityCap.UnitData var1);

        public abstract void addPoint(IAbility var1);

        public abstract void applyStats(EntityCap.UnitData var1, PlayerEntity var2);

        public abstract AllocatedAbilitiesData getAbilitiesData();

        public abstract BaseSpell getSpellByKeybind(int var1, SpellCastingData.Hotbar var2);

        public abstract SpellCastingData getCastingData();

        public abstract boolean canCastRightClickSpell(BaseSpell var1, PlayerEntity var2);

        public abstract List<BaseSpell> getAvailableSpells();

        public abstract int getLevelOf(IAbility var1);

        public abstract boolean hasSynergy(Synergy var1);

        public abstract void reset();
    }
}

