/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability.player;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.packets.sync_cap.PlayerCaps;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.LvlPointStat;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.PlayerStatPointsData;
import com.robertx22.mine_and_slash.saveclasses.player_stat_points.SingleStatPointData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonPlayerCap;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.base.LoadSave;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerStatsPointsCap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "player_stat_points");
    private static final String LOC = "PLAYER_STAT_POINTS_DATA";
    @CapabilityInject(value=IPlayerStatPointsData.class)
    public static final Capability<IPlayerStatPointsData> Data = null;

    public static class Storage
    extends BaseStorage<IPlayerStatPointsData> {
    }

    public static class DefaultImpl
    implements IPlayerStatPointsData {
        PlayerStatPointsData data = new PlayerStatPointsData();

        @Override
        public CompoundNBT saveToNBT() {
            CompoundNBT nbt = new CompoundNBT();
            LoadSave.Save(this.data, nbt, PlayerStatsPointsCap.LOC);
            return nbt;
        }

        @Override
        public PlayerCaps getCapType() {
            return PlayerCaps.STAT_POINTS;
        }

        @Override
        public void loadFromNBT(CompoundNBT nbt) {
            this.data = LoadSave.Load(PlayerStatPointsData.class, new PlayerStatPointsData(), nbt, PlayerStatsPointsCap.LOC);
        }

        @Override
        public int getAvailablePoints(EntityCap.UnitData data) {
            int avail = this.getPointsForLevel(data.getLevel());
            return avail - this.data.getCurrentlyAllocatedPointAmount();
        }

        public int getPointsForLevel(int lvl) {
            return (int)((double)lvl * (Double)ModConfig.INSTANCE.Server.STAT_POINTS_PER_LEVEL.get());
        }

        @Override
        public boolean hasAvailablePoints(EntityCap.UnitData data) {
            return this.getAvailablePoints(data) > 0;
        }

        @Override
        public void resetStats() {
            this.data.getAllStatDatas().forEach(x -> {
                x.points = 0;
            });
        }

        @Override
        public PlayerStatPointsData getData() {
            return this.data;
        }

        @Override
        public SingleStatPointData getStatData(LvlPointStat stat) {
            Optional<SingleStatPointData> opt = this.data.getAllStatDatas().stream().filter(x -> x.stat.equals((Object)stat)).findFirst();
            if (opt.isPresent()) {
                return opt.get();
            }
            return new SingleStatPointData();
        }

        @Override
        public void addPoint(PlayerEntity player, LvlPointStat stat, EntityCap.UnitData data) {
            if (this.hasAvailablePoints(data)) {
                ++this.getStatData((LvlPointStat)stat).points;
                data.setEquipsChanged(true);
                data.tryRecalculateStats((LivingEntity)player);
                data.syncToClient(player);
            }
        }
    }

    public static class Provider
    extends BaseProvider<IPlayerStatPointsData> {
        @Override
        public IPlayerStatPointsData defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<IPlayerStatPointsData> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(RESOURCE, (ICapabilityProvider)new Provider());
            }
        }
    }

    public static interface IPlayerStatPointsData
    extends ICommonPlayerCap {
        public SingleStatPointData getStatData(LvlPointStat var1);

        public void addPoint(PlayerEntity var1, LvlPointStat var2, EntityCap.UnitData var3);

        public int getAvailablePoints(EntityCap.UnitData var1);

        public boolean hasAvailablePoints(EntityCap.UnitData var1);

        public void resetStats();

        public PlayerStatPointsData getData();
    }
}

