/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.capability.server_wide;

import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.saveclasses.PlayerTeamsData;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseProvider;
import com.robertx22.mine_and_slash.uncommon.capability.bases.BaseStorage;
import com.robertx22.mine_and_slash.uncommon.capability.bases.ICommonCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.base.LoadSave;
import com.robertx22.mine_and_slash.uncommon.wrappers.SText;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TeamCap {
    static ITeamData data;
    public static final ResourceLocation RESOURCE;
    @CapabilityInject(value=ITeamData.class)
    public static final Capability<ITeamData> Data;
    static String DATA_LOC;

    public static ITeamData getCapability() {
        if (data == null) {
            data = new DefaultImpl();
        }
        return data;
    }

    static {
        RESOURCE = new ResourceLocation("mmorpg", "teams");
        Data = null;
        DATA_LOC = "mmorpg:data";
    }

    public static class Storage
    extends BaseStorage<ITeamData> {
    }

    public static class DefaultImpl
    implements ITeamData {
        PlayerTeamsData teams = new PlayerTeamsData();

        @Override
        public CompoundNBT saveToNBT() {
            CompoundNBT nbt = new CompoundNBT();
            if (this.teams != null) {
                LoadSave.Save(this.teams, nbt, DATA_LOC);
            }
            return nbt;
        }

        @Override
        public void loadFromNBT(CompoundNBT nbt) {
            this.teams = LoadSave.Load(PlayerTeamsData.class, new PlayerTeamsData(), nbt, DATA_LOC);
            if (this.teams == null) {
                this.teams = new PlayerTeamsData();
            }
        }

        @Override
        public boolean isOnSameTeam(ServerPlayerEntity p1, ServerPlayerEntity p2) {
            try {
                String id1 = this.teams.getTeamId((PlayerEntity)p1);
                String id2 = this.teams.getTeamId((PlayerEntity)p2);
                if (id1.isEmpty() || id2.isEmpty()) {
                    return false;
                }
                return id1.equals(id2);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public void joinTeam(ServerPlayerEntity player, String teamID) {
            try {
                PlayerTeamsData.Team team = this.teams.teamIDxTeamDataMap.get(teamID);
                if (team.tryJoin(player)) {
                    this.teams.playerIDxTeamIDMap.put(PlayerTeamsData.getPlayerId((PlayerEntity)player), teamID);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void createTeam(ServerPlayerEntity player) {
            try {
                if (this.isPlayerInATeam(player)) {
                    player.func_145747_a((ITextComponent)new SText("Can't create a team if you're already in one. Leave first."));
                } else {
                    PlayerTeamsData.Team team = new PlayerTeamsData.Team();
                    team.addPlayer(player);
                    String teamID = UUID.randomUUID().toString();
                    this.teams.playerIDxTeamIDMap.put(PlayerTeamsData.getPlayerId((PlayerEntity)player), teamID);
                    this.teams.teamIDxTeamDataMap.put(teamID, team);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean isPlayerInATeam(ServerPlayerEntity player) {
            try {
                PlayerTeamsData.Team team = this.teams.teamIDxTeamDataMap.get(this.teams.getTeamId((PlayerEntity)player));
                String id = PlayerTeamsData.getPlayerId((PlayerEntity)player);
                return team != null && team.getPlayerIds().contains(id);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public void invite(ServerPlayerEntity player, String teamID) {
            try {
                this.teams.teamIDxTeamDataMap.get(teamID).invite(player);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void leaveTeam(ServerPlayerEntity player) {
            try {
                if (!this.isPlayerInATeam(player)) {
                    player.func_145747_a((ITextComponent)new SText("You are not inside a team."));
                } else {
                    this.teams.playerIDxTeamIDMap.remove(this.teams.getTeamId((PlayerEntity)player));
                    this.teams.teamIDxTeamDataMap.get(this.teams.getTeamId((PlayerEntity)player)).removePlayer(player);
                    player.func_145747_a((ITextComponent)new SText("Left team."));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public String getTeamId(ServerPlayerEntity player) {
            return this.teams.getTeamId((PlayerEntity)player);
        }

        @Override
        public List<PlayerEntity> getPlayersInTeam(ServerPlayerEntity player) {
            ArrayList<PlayerEntity> list = new ArrayList<PlayerEntity>();
            list.add((PlayerEntity)player);
            try {
                this.teams.teamIDxTeamDataMap.get(this.teams.getTeamId((PlayerEntity)player)).getPlayerIds().stream().forEach(x -> {
                    ServerPlayerEntity p2;
                    if (x != null && (p2 = MapManager.getServer().func_184103_al().func_177451_a(UUID.fromString(x))) != null && p2 != player) {
                        list.add((PlayerEntity)p2);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return list;
        }
    }

    public static class Provider
    extends BaseProvider<ITeamData> {
        @Override
        public ITeamData defaultImpl() {
            return new DefaultImpl();
        }

        @Override
        public Capability<ITeamData> dataInstance() {
            return Data;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityConstruct(AttachCapabilitiesEvent<World> event) {
        }
    }

    public static interface ITeamData
    extends ICommonCap {
        public boolean isOnSameTeam(ServerPlayerEntity var1, ServerPlayerEntity var2);

        public void joinTeam(ServerPlayerEntity var1, String var2);

        public void createTeam(ServerPlayerEntity var1);

        public boolean isPlayerInATeam(ServerPlayerEntity var1);

        public void invite(ServerPlayerEntity var1, String var2);

        public void leaveTeam(ServerPlayerEntity var1);

        public String getTeamId(ServerPlayerEntity var1);

        public List<PlayerEntity> getPlayersInTeam(ServerPlayerEntity var1);
    }
}

