/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.datasaving;

import com.robertx22.mine_and_slash.uncommon.item_filters.bases.ItemFilterGroup;
import com.robertx22.mine_and_slash.uncommon.localization.Styles;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public enum ItemType {
    GEAR(ItemFilterGroup.ANY_GEAR, Words.Gears),
    MAP(ItemFilterGroup.ANY_MAP, Words.Map),
    NONE(null, Words.None);

    private ItemFilterGroup filter;
    public Words word;

    private ItemType(ItemFilterGroup filter, Words word) {
        this.filter = filter;
        this.word = word;
    }

    public boolean isType(ItemStack stack) {
        if (this.filter == null) {
            return false;
        }
        return this.filter.anyMatchesFilter(stack);
    }

    public static ITextComponent getTooltipString(ItemType types) {
        ITextComponent comp = Styles.LIGHT_PURPLECOMP().func_150257_a(Words.UsableOn.locName()).func_150258_a(": ").func_150257_a(types.word.locName());
        return comp;
    }

    public static ItemType getType(ItemStack stack) {
        for (ItemType type : ItemType.values()) {
            if (!type.isType(stack)) continue;
            return type;
        }
        return NONE;
    }
}

