/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.datasaving;

import com.robertx22.mine_and_slash.uncommon.capability.entity.BossCap;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerMapCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerStatsPointsCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerTalentsCap;
import com.robertx22.mine_and_slash.uncommon.capability.server_wide.PlayerCapBackupCap;
import com.robertx22.mine_and_slash.uncommon.capability.world.AntiMobFarmCap;
import com.robertx22.mine_and_slash.uncommon.capability.world.WorldMapCap;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class Load {
    public static boolean hasUnit(ICapabilityProvider provider) {
        if (provider != null) {
            return provider.getCapability(EntityCap.Data).isPresent();
        }
        return false;
    }

    public static boolean isBoss(ICapabilityProvider provider) {
        if (provider != null && provider.getCapability(BossCap.Data).isPresent()) {
            return ((BossCap.IBossData)provider.getCapability(BossCap.Data).orElse((Object)new BossCap.DefaultImpl())).isBoss();
        }
        return false;
    }

    public static PlayerStatsPointsCap.IPlayerStatPointsData statPoints(PlayerEntity provider) {
        if (provider != null) {
            return (PlayerStatsPointsCap.IPlayerStatPointsData)provider.getCapability(PlayerStatsPointsCap.Data).orElse((Object)new PlayerStatsPointsCap.DefaultImpl());
        }
        return null;
    }

    @Nonnull
    public static WorldMapCap.IWorldMapData world(World provider) {
        LazyOptional mapData = provider.getCapability(WorldMapCap.Data);
        return (WorldMapCap.IWorldMapData)mapData.orElse((Object)new WorldMapCap.DefaultImpl());
    }

    @Nonnull
    public static PlayerTalentsCap.IPlayerTalentsData talents(PlayerEntity provider) {
        return (PlayerTalentsCap.IPlayerTalentsData)provider.getCapability(PlayerTalentsCap.Data).orElse((Object)new PlayerTalentsCap.DefaultImpl());
    }

    @Nonnull
    public static PlayerSpellCap.ISpellsCap spells(LivingEntity provider) {
        if (provider instanceof PlayerEntity) {
            return (PlayerSpellCap.ISpellsCap)provider.getCapability(PlayerSpellCap.Data).orElse((Object)new PlayerSpellCap.DefaultImpl());
        }
        return new PlayerSpellCap.DefaultImpl();
    }

    public static PlayerCapBackupCap.IPlayerCapBackupData playersCapBackup(World world) {
        if (world != null) {
            return (PlayerCapBackupCap.IPlayerCapBackupData)world.getCapability(PlayerCapBackupCap.Data).orElse((Object)new PlayerCapBackupCap.DefaultImpl());
        }
        return null;
    }

    public static EntityCap.UnitData Unit(ICapabilityProvider provider) {
        if (provider != null) {
            return (EntityCap.UnitData)provider.getCapability(EntityCap.Data).orElse((Object)new EntityCap.DefaultImpl());
        }
        return null;
    }

    public static BossCap.IBossData boss(ICapabilityProvider provider) {
        if (provider != null) {
            return (BossCap.IBossData)provider.getCapability(BossCap.Data).orElse((Object)new BossCap.DefaultImpl());
        }
        return null;
    }

    public static AntiMobFarmCap.IAntiMobFarmData antiMobFarm(World provider) {
        if (provider != null) {
            return (AntiMobFarmCap.IAntiMobFarmData)provider.getCapability(AntiMobFarmCap.Data).orElse((Object)new AntiMobFarmCap.DefaultImpl());
        }
        return null;
    }

    public static PlayerMapCap.IPlayerMapData playerMapData(PlayerEntity provider) {
        if (provider != null) {
            return (PlayerMapCap.IPlayerMapData)provider.getCapability(PlayerMapCap.Data).orElse((Object)new PlayerMapCap.DefaultImpl());
        }
        return null;
    }
}

