/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.develeper;

import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.develeper.CreateLangFileUtils;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocMultiLore;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.AdvDescs;
import com.robertx22.mine_and_slash.uncommon.localization.AdvTitles;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.DirUtils;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CreateLangFile {
    public static void create() {
        String json = "{\n" + DirUtils.getManualString();
        ArrayList<String> usedGUIDS = new ArrayList<String>();
        for (Map.Entry<String, List<IAutoLocName>> entry : CreateLangFile.getMap().entrySet()) {
            json = json + CreateLangFileUtils.comment(entry.getKey());
            for (IBaseAutoLoc iauto : entry.getValue()) {
                if (!iauto.shouldRegisterLangName() || iauto.locNameForLangFile().isEmpty()) continue;
                if (iauto.locNameForLangFile().contains("\"")) {
                    try {
                        throw new Exception(iauto.locNameForLangFile() + " contains double \"");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (usedGUIDS.contains(iauto.formattedLocNameLangFileGUID())) continue;
                usedGUIDS.add(iauto.formattedLocNameLangFileGUID());
                json = json + "\t\"" + iauto.formattedLocNameLangFileGUID() + "\": \"" + iauto.locNameForLangFile() + "\",\n";
            }
            json = json + CreateLangFileUtils.comment(entry.getKey());
        }
        usedGUIDS.clear();
        for (Map.Entry<String, List<IBaseAutoLoc>> entry : CreateLangFile.getDescMap().entrySet()) {
            json = json + CreateLangFileUtils.comment(entry.getKey());
            for (IBaseAutoLoc iauto : entry.getValue()) {
                if (!iauto.shouldRegisterLangDesc() || iauto.locDescForLangFile().isEmpty()) continue;
                if (iauto.locDescForLangFile().contains("\"")) {
                    try {
                        throw new Exception(iauto.locDescForLangFile() + " contains double \"");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (usedGUIDS.contains(iauto.formattedLocDescLangFileGUID())) continue;
                usedGUIDS.add(iauto.formattedLocDescLangFileGUID());
                json = json + "\t\"" + iauto.formattedLocDescLangFileGUID() + "\": \"" + iauto.locDescForLangFile() + "\",\n";
            }
            json = json + CreateLangFileUtils.comment(entry.getKey());
        }
        usedGUIDS.clear();
        for (Map.Entry<String, List<IBaseAutoLoc>> entry : CreateLangFile.getMultiLoreMap().entrySet()) {
            json = json + CreateLangFileUtils.comment(entry.getKey());
            for (IBaseAutoLoc iauto : entry.getValue()) {
                if (usedGUIDS.contains(iauto.formattedLocLoresLangFileGUID())) continue;
                usedGUIDS.add(iauto.formattedLocLoresLangFileGUID());
                if (iauto.loreLines().size() <= 0) continue;
                int i = 0;
                for (String line : iauto.loreLines()) {
                    json = json + "\t\"" + iauto.getPrefixListForLangFile().get(i) + iauto.formattedLocLoresLangFileGUID() + "\": \"" + line + "\",\n";
                    ++i;
                }
            }
            json = json + CreateLangFileUtils.comment(entry.getKey());
        }
        json = json + "\n}";
        json = CreateLangFileUtils.replaceLast(json, ",", "");
        try {
            System.out.println("Starting to create lang file");
            if (!Files.exists(Paths.get(DirUtils.langFilePath(), new String[0]), new LinkOption[0])) {
                Files.createFile(Paths.get(DirUtils.langFilePath(), new String[0]), new FileAttribute[0]);
            }
            File file = new File(DirUtils.langFilePath());
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(json);
            fileWriter.close();
            System.out.println("Saved lang file to " + file.toPath().toString());
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static HashMap<String, List<IAutoLocName>> getMap() {
        List<IAutoLocName> list = CreateLangFileUtils.getFromRegistries(IAutoLocName.class);
        list.addAll(SlashRegistry.Sets().getSerializable());
        list.addAll(SlashRegistry.MobAffixes().getSerializable());
        list.addAll(SlashRegistry.RuneWords().getSerializable());
        list.addAll(SlashRegistry.UniqueGears().getSerializable());
        list.addAll(SlashRegistry.Affixes().getSerializable());
        list.addAll(SlashRegistry.Synergies().getList());
        list.addAll(SlashRegistry.Stats().getAll().values());
        list.addAll(SlashRegistry.GearTypes().getAll().values());
        list.addAll(SlashRegistry.WorldProviders().getAll().values());
        list.addAll(Arrays.asList(Words.values()));
        list.addAll(Rarities.Gears.getAllRarities());
        list.addAll(Rarities.Mobs.getAllRarities());
        list.addAll(Arrays.asList(Chats.values()));
        list.addAll(Arrays.asList(AdvDescs.values()));
        list.addAll(Arrays.asList(AdvTitles.values()));
        HashMap map = new HashMap();
        for (IBaseAutoLoc.AutoLocGroup autoLocGroup : IBaseAutoLoc.AutoLocGroup.values()) {
            map.put(autoLocGroup, list.stream().filter(x -> x.locNameGroup().equals((Object)autoLocGroup)).collect(Collectors.toList()));
        }
        HashMap<String, List<IAutoLocName>> sortedMap = new HashMap<String, List<IAutoLocName>>();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<IAutoLocName> sortedlist = new ArrayList<IAutoLocName>((Collection)entry.getValue());
            CreateLangFileUtils.sortName(sortedlist);
            if (sortedlist.size() <= 0) continue;
            sortedMap.put(((IAutoLocName)((List)entry.getValue()).get(0)).getGroupName(), sortedlist);
        }
        return sortedMap;
    }

    public static HashMap<String, List<IAutoLocDesc>> getDescMap() {
        List<IAutoLocDesc> list = CreateLangFileUtils.getFromRegistries(IAutoLocDesc.class);
        list.addAll(SlashRegistry.UniqueGears().getSerializable());
        list.addAll(SlashRegistry.Stats().getAll().values());
        HashMap map = new HashMap();
        for (IBaseAutoLoc.AutoLocGroup autoLocGroup : IBaseAutoLoc.AutoLocGroup.values()) {
            map.put(autoLocGroup, list.stream().filter(x -> x.locDescGroup().equals((Object)autoLocGroup)).collect(Collectors.toList()));
        }
        HashMap<String, List<IAutoLocDesc>> sortedMap = new HashMap<String, List<IAutoLocDesc>>();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<IAutoLocDesc> sortedlist = new ArrayList<IAutoLocDesc>((Collection)entry.getValue());
            CreateLangFileUtils.sortDesc(sortedlist);
            if (sortedlist.size() <= 0) continue;
            sortedMap.put(((IAutoLocDesc)((List)entry.getValue()).get(0)).getDescGroupName(), sortedlist);
        }
        return sortedMap;
    }

    public static HashMap<String, List<IAutoLocMultiLore>> getMultiLoreMap() {
        List<IAutoLocMultiLore> list = CreateLangFileUtils.getFromRegistries(IAutoLocMultiLore.class);
        HashMap map = new HashMap();
        for (IBaseAutoLoc.AutoLocGroup autoLocGroup : IBaseAutoLoc.AutoLocGroup.values()) {
            map.put(autoLocGroup, list.stream().filter(x -> x.locLoresGroup().equals((Object)autoLocGroup)).collect(Collectors.toList()));
        }
        HashMap<String, List<IAutoLocMultiLore>> sortedMap = new HashMap<String, List<IAutoLocMultiLore>>();
        for (Map.Entry entry : map.entrySet()) {
            ArrayList<IAutoLocMultiLore> sortedlist = new ArrayList<IAutoLocMultiLore>((Collection)entry.getValue());
            CreateLangFileUtils.sortLores(sortedlist);
            if (sortedlist.size() <= 0) continue;
            sortedMap.put(((IAutoLocMultiLore)((List)entry.getValue()).get(0)).getMultiGroupName(), sortedlist);
        }
        return sortedMap;
    }
}

