/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.develeper;

import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocMultiLore;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class CreateLangFileUtils {
    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length(), string.length());
        }
        return string;
    }

    public static String comment(String str) {
        return "\n\"_comment\": \" [CATEGORY]: " + str + "\",\n\n";
    }

    public static boolean matches(ResourceLocation loc) {
        return loc != null && loc.func_110624_b().equals("mmorpg");
    }

    public static <T extends IBaseAutoLoc> List<T> getFromRegistries(Class<T> theclass) {
        ArrayList<IBaseAutoLoc> list = new ArrayList<IBaseAutoLoc>();
        for (Item item : ForgeRegistries.ITEMS) {
            if (!CreateLangFileUtils.matches(item.getRegistryName()) || !theclass.isAssignableFrom(item.getClass())) continue;
            list.add((IBaseAutoLoc)item);
        }
        for (Item item : ForgeRegistries.BLOCKS) {
            if (!CreateLangFileUtils.matches(item.getRegistryName()) || !theclass.isAssignableFrom(item.getClass())) continue;
            list.add((IBaseAutoLoc)item);
        }
        for (Item item : ForgeRegistries.POTIONS) {
            if (!CreateLangFileUtils.matches(item.getRegistryName()) || !theclass.isAssignableFrom(item.getClass())) continue;
            list.add((IBaseAutoLoc)item);
        }
        return list;
    }

    public static void sortName(List<IAutoLocName> list) {
        if (list != null && list.size() > 1) {
            try {
                Collections.sort(list, Comparator.comparing(x -> x.locNameLangFileGUID()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void sortDesc(List<IAutoLocDesc> list) {
        if (list != null && list.size() > 1) {
            try {
                Collections.sort(list, Comparator.comparing(x -> x.locDescLangFileGUID()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void sortLores(List<IAutoLocMultiLore> list) {
        if (list != null && list.size() > 1) {
            try {
                Collections.sort(list, Comparator.comparing(x -> x.formattedGUID()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

