/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas;

import com.robertx22.mine_and_slash.api.MineAndSlashEvents;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.database.spells.spell_classes.bases.MyDamageSource;
import com.robertx22.mine_and_slash.database.spells.synergies.base.OnBasicAttackSynergy;
import com.robertx22.mine_and_slash.database.spells.synergies.base.OnDamageDoneSynergy;
import com.robertx22.mine_and_slash.database.stats.effects.defense.BlockEffect;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.onevent.entity.damage.DamageEventData;
import com.robertx22.mine_and_slash.onevent.entity.damage.DmgSourceUtils;
import com.robertx22.mine_and_slash.packets.DmgNumPacket;
import com.robertx22.mine_and_slash.potion_effects.bases.IOnBasicAttackPotion;
import com.robertx22.mine_and_slash.potion_effects.bases.IOnBasicAttackedPotion;
import com.robertx22.mine_and_slash.saveclasses.ResourcesData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.SpellDamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IArmorReducable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.ICrittable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IDamageEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IElementalPenetrable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IElementalResistable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.IPenetrable;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.HealthUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TeamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.SwordItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;

public class DamageEffect
extends EffectData
implements IArmorReducable,
IPenetrable,
IDamageEffect,
IElementalResistable,
IElementalPenetrable,
ICrittable {
    LivingHurtEvent event;
    private HashMap<Elements, Integer> bonusElementDamageMap = new HashMap();
    public static String dmgSourceName = "mmorpg.custom_damage";
    public Elements element = Elements.Physical;
    public int armorPene;
    public int elementalPene;
    public float damageMultiplier = 1.0f;
    public float healthHealed;
    public float magicShieldRestored;
    public float manaRestored;
    public boolean isFullyBlocked = false;
    public boolean isPartiallyBlocked = false;
    public boolean isDodged = false;
    boolean removeKnockback = false;
    public boolean crit = false;

    public DamageEffect(LivingHurtEvent event, LivingEntity source, LivingEntity target, int dmg, EntityCap.UnitData sourceData, EntityCap.UnitData targetData, EffectData.EffectTypes effectType, WeaponTypes weptype) {
        super(source, target, sourceData, targetData);
        this.setEffectType(effectType, weptype);
        this.number = dmg;
        this.event = event;
    }

    public DamageEffect(DamageEventData data, int dmg, EffectData.EffectTypes effectType, WeaponTypes weptype) {
        super(data.source, data.target, data.sourceData, data.targetData);
        this.setEffectType(effectType, weptype);
        this.number = dmg;
        this.event = data.event;
    }

    public DamageEffect(LivingHurtEvent event, LivingEntity source, LivingEntity target, int dmg, EffectData.EffectTypes effectType, WeaponTypes weptype) {
        super(source, target, Load.Unit((ICapabilityProvider)source), Load.Unit((ICapabilityProvider)target));
        this.setEffectType(effectType, weptype);
        this.number = dmg;
        this.event = event;
    }

    public boolean isElemental() {
        return this.element != null && this.element != Elements.Physical;
    }

    public Elements getHighestBonusElementalDamageElement() {
        int highest = 0;
        Elements ele = null;
        for (Map.Entry<Elements, Integer> entry : this.bonusElementDamageMap.entrySet()) {
            if (entry.getValue() <= highest) continue;
            ele = entry.getKey();
            highest = entry.getValue();
        }
        return ele;
    }

    public void addBonusEleDmgDivideByMulti(Elements element, float dmg) {
        this.addBonusEleDmg(element, dmg / this.damageMultiplier);
    }

    public void addBonusEleDmg(Elements element, float dmg) {
        if (this.bonusElementDamageMap.containsKey(element)) {
            this.bonusElementDamageMap.put(element, (int)((float)this.bonusElementDamageMap.get(element).intValue() + dmg));
        } else {
            this.bonusElementDamageMap.put(element, (int)dmg);
        }
    }

    public boolean isBlocked() {
        return this.isFullyBlocked || this.isPartiallyBlocked;
    }

    public boolean isDmgAllowed() {
        return !this.isFullyBlocked && !this.isDodged;
    }

    public float getActualDamage() {
        float dmg = this.number * this.damageMultiplier;
        if (dmg <= 0.0f) {
            return 0.0f;
        }
        dmg = HealthUtils.DamageToMinecraftHealth(dmg, this.target, this.targetData);
        return dmg;
    }

    public float getVisibleDamage() {
        float dmg = this.number * this.damageMultiplier;
        return dmg;
    }

    public float getEventDmg() {
        if (this.event != null) {
            return this.event.getAmount();
        }
        return 0.0f;
    }

    public void removeKnockback() {
        this.removeKnockback = true;
    }

    public boolean areBothPlayers() {
        return this.source instanceof ServerPlayerEntity && this.target instanceof ServerPlayerEntity;
    }

    public void cancelDamage() {
        this.canceled = true;
        if (this.event != null) {
            this.event.setAmount(0.0f);
            this.event.setCanceled(true);
        }
    }

    private void activateSynergies() {
        if (this.activateSynergies) {
            if (this instanceof SpellDamageEffect) {
                SpellDamageEffect e = (SpellDamageEffect)this;
                e.spell.getAllocatedSynergies(Load.spells(e.source)).forEach(x -> {
                    if (x instanceof OnDamageDoneSynergy) {
                        OnDamageDoneSynergy s = (OnDamageDoneSynergy)x;
                        s.tryActivate(e);
                    }
                });
            } else if (this.getEffectType().equals((Object)EffectData.EffectTypes.BASIC_ATTACK)) {
                PlayerSpellCap.ISpellsCap cap = Load.spells(this.source);
                cap.getAbilitiesData().getAllocatedSynergies().forEach(x -> {
                    if (x instanceof OnBasicAttackSynergy) {
                        OnBasicAttackSynergy s = (OnBasicAttackSynergy)x;
                        s.tryActivate(this);
                    }
                });
            }
        }
    }

    @Override
    protected void activate() {
        TameableEntity tame;
        if (this.target.func_110143_aJ() <= 0.0f || !this.target.func_70089_S()) {
            return;
        }
        if (this.areBothPlayers()) {
            if (TeamUtils.areOnSameTeam((PlayerEntity)((ServerPlayerEntity)this.source), (PlayerEntity)((ServerPlayerEntity)this.target))) {
                return;
            }
        } else if (this instanceof SpellDamageEffect && this.target instanceof TameableEntity && this.source instanceof PlayerEntity && (tame = (TameableEntity)this.target).func_152114_e(this.source)) {
            this.cancelDamage();
            return;
        }
        if (this.removeKnockback || this.isFullyBlocked) {
            BlockEffect.applyKnockbackResist(this.target);
        }
        if (!this.isDmgAllowed()) {
            this.cancelDamage();
            return;
        }
        DmgByElement info = this.getDmgByElement();
        float dmg = info.totalDmg;
        if (this.getEffectType().equals((Object)EffectData.EffectTypes.BASIC_ATTACK) && this.weaponType != null && this.weaponType.isMelee && this.source instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)this.source;
            float cooldown = this.sourceData.getAttackCooldown();
            dmg *= 0.2f + cooldown * cooldown * 0.8f;
            if (cooldown > 0.9f && !(player.func_184607_cu().func_77973_b() instanceof SwordItem)) {
                player.func_184810_cG();
            }
            if (cooldown < 0.1f || dmg <= 0.0f) {
                if (this.event != null) {
                    player.func_184821_cY();
                    this.event.setCanceled(true);
                }
                return;
            }
        }
        if (this.canceled) {
            this.cancelDamage();
            return;
        }
        DamageSource ds = null;
        if (this.event != null) {
            ds = this.event.getSource();
        }
        MyDamageSource dmgsource = new MyDamageSource(ds, dmgSourceName, (Entity)this.source, this.element, (int)this.number);
        if (this.isPartiallyBlocked) {
            dmgsource.func_76348_h();
        }
        if (this.isDodged) {
            this.cancelDamage();
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new MineAndSlashEvents.OnDmgDoneEvent(this.source, this));
            this.activateSynergies();
            this.sourceData.onAttackEntity(this.source, this.target);
            dmg += this.getEventDmg() * ((Double)ModConfig.INSTANCE.Server.NON_MOD_DAMAGE_MULTI.get()).floatValue();
            if (this.event != null) {
                this.event.setAmount(dmg);
                this.event.getSource().func_76348_h();
                this.event.getSource().func_151518_m();
                DmgSourceUtils.markSourceAsMine(this.event.getSource());
            } else {
                int hurtResistantTime = this.target.field_70172_ad;
                this.target.field_70172_ad = 0;
                this.target.func_70097_a((DamageSource)dmgsource, dmg);
                this.target.field_70172_ad = hurtResistantTime;
            }
            this.Heal();
            this.RestoreMana();
            this.restoreMagicShield();
            if (dmg > 0.0f) {
                this.onEventPotions();
                if (this.source instanceof ServerPlayerEntity) {
                    info.dmgmap.entrySet().forEach(x -> {
                        if (((Float)x.getValue()).floatValue() > 0.0f) {
                            ServerPlayerEntity player = (ServerPlayerEntity)this.source;
                            String str = NumberUtils.formatDamageNumber(this, (int)HealthUtils.vanillaHealthToActualHealth(((Float)x.getValue()).floatValue(), this.target, this.targetData));
                            DmgNumPacket packet = new DmgNumPacket(this.target, (Elements)x.getKey(), str);
                            MMORPG.sendToClient(packet, player);
                        }
                    });
                }
            }
        }
        BlockEffect.removeKnockbackResist(this.target);
    }

    private void onEventPotions() {
        if (this.getEffectType() == EffectData.EffectTypes.BASIC_ATTACK) {
            List<EffectInstance> onAttacks = this.source.func_70651_bq().stream().filter(x -> x.func_188419_a() instanceof IOnBasicAttackPotion).collect(Collectors.toList());
            onAttacks.forEach(x -> ((IOnBasicAttackPotion)x.func_188419_a()).OnBasicAttack(this.source, this.target));
            List<EffectInstance> onAttackeds = this.target.func_70651_bq().stream().filter(x -> x.func_188419_a() instanceof IOnBasicAttackedPotion).collect(Collectors.toList());
            onAttackeds.forEach(x -> ((IOnBasicAttackedPotion)x.func_188419_a()).onBasicAttacked((EffectInstance)x, this.source, this.target));
        }
    }

    public void RestoreMana() {
        int restored = (int)this.manaRestored;
        if (restored > 0) {
            this.sourceData.getResources().modify(new ResourcesData.Context(this.sourceData, this.source, ResourcesData.Type.MANA, restored, ResourcesData.Use.RESTORE));
        }
    }

    public void Heal() {
        int healed = (int)this.healthHealed;
        if (healed > 0) {
            this.sourceData.getResources().modify(new ResourcesData.Context(this.sourceData, this.source, ResourcesData.Type.HEALTH, healed, ResourcesData.Use.RESTORE));
        }
    }

    public void restoreMagicShield() {
        int healed = (int)this.magicShieldRestored;
        if (healed > 0) {
            this.sourceData.getResources().modify(new ResourcesData.Context(this.sourceData, this.source, ResourcesData.Type.MAGIC_SHIELD, healed, ResourcesData.Use.RESTORE));
        }
    }

    public DamageEffect setMultiplier(float multi) {
        this.damageMultiplier = multi;
        return this;
    }

    public DmgByElement getDmgByElement() {
        DmgByElement info = new DmgByElement();
        for (Map.Entry<Elements, Integer> entry : this.bonusElementDamageMap.entrySet()) {
            if (entry.getValue() <= 0) continue;
            DamageEffect bonus = new DamageEffect(null, this.source, this.target, entry.getValue(), this.sourceData, this.targetData, EffectData.EffectTypes.BONUS_ATTACK, this.weaponType);
            bonus.element = entry.getKey();
            bonus.damageMultiplier = this.damageMultiplier;
            bonus.calculateEffects();
            info.addDmg(bonus.getActualDamage(), bonus.element);
        }
        info.addDmg(this.getActualDamage(), this.element);
        return info;
    }

    @Override
    public LivingEntity Source() {
        return this.source;
    }

    @Override
    public LivingEntity Target() {
        return this.target;
    }

    @Override
    public float Number() {
        return this.number;
    }

    @Override
    public Elements GetElement() {
        return this.element;
    }

    @Override
    public void SetArmorPenetration(int val) {
        this.armorPene = val;
    }

    @Override
    public void addElementalPenetration(int val) {
        this.elementalPene += val;
    }

    @Override
    public int GetArmorPenetration() {
        return this.armorPene;
    }

    @Override
    public void setCrit(boolean bool) {
        this.crit = bool;
    }

    @Override
    public boolean isCriticalHit() {
        return this.crit;
    }

    @Override
    public int GetElementalPenetration() {
        return this.elementalPene;
    }

    public static class DmgByElement {
        public HashMap<Elements, Float> dmgmap = new HashMap();
        public Elements highestDmgElement;
        public float highestDmgValue;
        public float totalDmg = 0.0f;

        public void addDmg(float dmg, Elements element) {
            Elements ele = element;
            if (ele == null) {
                ele = Elements.Physical;
            }
            float total = this.dmgmap.getOrDefault(element, Float.valueOf(0.0f)).floatValue() + dmg;
            this.dmgmap.put(ele, Float.valueOf(total));
            this.totalDmg += dmg;
            if (total > this.highestDmgValue) {
                this.highestDmgElement = ele;
                this.highestDmgValue = total;
            }
        }
    }
}

