/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.effectdatas;

import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectUnitStat;
import com.robertx22.mine_and_slash.uncommon.effectdatas.interfaces.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class EffectData {
    public EntityCap.UnitData sourceData;
    public EntityCap.UnitData targetData;
    public boolean canceled = false;
    public Unit sourceUnit;
    public Unit targetUnit;
    public LivingEntity source;
    public LivingEntity target;
    public float number = 0.0f;
    protected boolean activateSynergies = true;
    private EffectTypes effectType = EffectTypes.BASIC_ATTACK;
    public WeaponTypes weaponType = WeaponTypes.None;
    boolean effectsCalculated = false;

    public EffectData(LivingEntity source, LivingEntity target) {
        this.source = source;
        this.target = target;
        if (target != null) {
            this.targetData = Load.Unit((ICapabilityProvider)target);
        }
        if (source != null) {
            this.sourceData = Load.Unit((ICapabilityProvider)source);
        }
        if (source != null) {
            try {
                if (target != null) {
                    this.targetUnit = this.targetData.getUnit();
                }
                this.sourceUnit = this.sourceData.getUnit();
                if (this.sourceUnit != null) {
                    this.sourceData.tryRecalculateStats(source);
                } else {
                    this.canceled = true;
                }
                if (this.targetUnit != null) {
                    this.targetData.tryRecalculateStats(target);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public EffectData(LivingEntity source, LivingEntity target, EntityCap.UnitData sourceData, EntityCap.UnitData targetData) {
        this.source = source;
        this.target = target;
        if (sourceData != null && targetData != null) {
            this.sourceData = sourceData;
            this.targetData = targetData;
            this.sourceUnit = sourceData.getUnit();
            this.targetUnit = targetData.getUnit();
        } else {
            this.canceled = true;
        }
    }

    public EffectTypes getEffectType() {
        return this.effectType;
    }

    public void setEffectType(EffectTypes effectType, WeaponTypes weaponType) {
        this.effectType = effectType;
        this.weaponType = weaponType;
    }

    public Unit GetSource() {
        return this.sourceUnit;
    }

    public Unit GetTarget() {
        return this.targetUnit;
    }

    public void Activate() {
        this.calculateEffects();
        if (!this.canceled) {
            this.activate();
        }
    }

    public void calculateEffects() {
        if (!this.effectsCalculated) {
            this.effectsCalculated = true;
            if (this.source == null || this.target == null || this.canceled || this.sourceUnit == null || this.targetUnit == null || this.sourceData == null || this.targetData == null) {
                return;
            }
            this.logOnStartData();
            this.TryApplyEffects(this.GetSource(), IStatEffect.EffectSides.Source);
            this.TryApplyEffects(this.GetTarget(), IStatEffect.EffectSides.Target);
            this.logOnEndData();
        }
    }

    public void logOnStartData() {
        if (MMORPG.statEffectDebuggingEnabled()) {
            System.out.println(TextFormatting.DARK_PURPLE + "Starting to activate effects for: " + this.getClass().toString() + " Starting Number: " + this.number);
        }
    }

    public void logOnEndData() {
        if (MMORPG.statEffectDebuggingEnabled()) {
            System.out.println(TextFormatting.DARK_PURPLE + "Effects for : " + this.getClass().toString() + " are finished.");
        }
    }

    public void logAfterEffect(IStatEffect effect) {
        if (MMORPG.statEffectDebuggingEnabled()) {
            System.out.println(TextFormatting.GREEN + "After : " + TextFormatting.BLUE + effect.getClass().toString() + TextFormatting.WHITE + ": " + this.number);
        }
    }

    protected abstract void activate();

    protected EffectData TryApplyEffects(Unit unit, IStatEffect.EffectSides side) {
        if (this.canceled) {
            return this;
        }
        List<EffectUnitStat> Effects2 = new ArrayList<EffectUnitStat>();
        Effects2 = this.AddEffects(Effects2, unit, side);
        Effects2.sort(new EffectUnitStat());
        for (EffectUnitStat item : Effects2) {
            if (!item.stat.isNotZero() || !item.effect.Side().equals((Object)side)) continue;
            item.effect.TryModifyEffect(this, item.source, item.stat, item.stat.GetStat());
        }
        return this;
    }

    private List<EffectUnitStat> AddEffects(List<EffectUnitStat> effects, Unit unit, IStatEffect.EffectSides side) {
        if (unit != null) {
            unit.getStats().values().forEach(data -> {
                Stat stat;
                if (data.isNotZero() && (stat = data.GetStat()) instanceof IStatEffects) {
                    ((IStatEffects)((Object)stat)).getEffects().forEach(effect -> effects.add(new EffectUnitStat((IStatEffect)effect, unit, (StatData)data)));
                }
            });
        }
        return effects;
    }

    public static enum EffectTypes {
        NORMAL,
        SPELL,
        BASIC_ATTACK,
        BONUS_ATTACK,
        REFLECT,
        DOT_DMG;

    }
}

