/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.enumclasses;

import com.robertx22.mine_and_slash.config.base_player_stat.BasePlayerStatContainer;
import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public enum Masteries {
    OCEAN("ocean", Elements.Water.format, Words.Ocean, 1, Chats.OceanMastery),
    FIRE("fire", Elements.Fire.format, Words.Fire, 2, Chats.FireMastery),
    STORM("storm", Elements.Thunder.format, Words.Storm, 3, Chats.StormMastery),
    NATURE("nature", Elements.Nature.format, Words.Nature, 4, Chats.NatureMastery),
    HUNTING("hunting", TextFormatting.GREEN, Words.Hunting, 5, Chats.HuntingMastery),
    DIVINE("divine", TextFormatting.WHITE, Words.Divine, 6, Chats.DivineMastery);

    public static int MAXIMUM_POINTS;
    public String id;
    public TextFormatting format;
    public Words locName;
    int place;
    public Chats desc;
    public static int LVL_TO_UNLOCK_2ND_SCHOOL;

    private Masteries(String id, TextFormatting format, Words locName, int place, Chats desc) {
        this.id = id;
        this.format = format;
        this.locName = locName;
        this.desc = desc;
        this.place = place;
    }

    public int getBarTexXOffset() {
        return 46 + (this.place - 1) * 21;
    }

    public ITextComponent getFullName() {
        return this.locName.locName().func_150258_a(" ").func_150257_a(Words.Mastery.locName());
    }

    public String getFullNameTranslated() {
        return this.locName.locNameForLangFile() + " " + Words.Mastery.locNameForLangFile();
    }

    public List<ExactStatData> getStatsFor(int schoolLevel, EntityCap.UnitData data) {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        BasePlayerStatContainer.INSTANCE.SPELL_MASTERY_STATS.entrySet().forEach(x -> list.add(new ExactStatData(((Double)x.getValue()).floatValue(), SlashRegistry.Stats().get((String)x.getKey()))));
        int level = this.getEffectiveLevel(schoolLevel);
        int lvl = MathHelper.func_76125_a((int)level, (int)0, (int)data.getLevel());
        list.sort(Comparator.comparingDouble(x -> x.getValue()));
        list.forEach(x -> x.scaleToLvl(lvl));
        return list;
    }

    public int getEffectiveLevel(PlayerSpellCap.ISpellsCap spells) {
        return this.getEffectiveLevel(spells.getAbilitiesData().getSchoolPoints(this));
    }

    public int getEffectiveLevel(int schoolLevel) {
        int level = (int)((float)((Integer)ModConfig.INSTANCE.Server.MAXIMUM_PLAYER_LEVEL.get()).intValue() * ((float)schoolLevel / (float)MAXIMUM_POINTS));
        return level;
    }

    public ResourceLocation getGuiIconLocation() {
        return new ResourceLocation("mmorpg", "textures/gui/spell_schools/schools/" + this.id + ".png");
    }

    static {
        MAXIMUM_POINTS = 50;
        LVL_TO_UNLOCK_2ND_SCHOOL = 10;
    }
}

