/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.stat_calculation;

import com.robertx22.mine_and_slash.database.stats.Trait;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.base.ICoreStat;
import com.robertx22.mine_and_slash.database.stats.types.core_stats.base.IPreCoreStat;
import com.robertx22.mine_and_slash.db_lists.initializers.Stats;
import com.robertx22.mine_and_slash.potion_effects.bases.IApplyStatPotion;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.saveclasses.gearitem.StatModData;
import com.robertx22.mine_and_slash.saveclasses.mapitem.MapAffixData;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import com.robertx22.mine_and_slash.uncommon.capability.player.PlayerSpellCap;
import com.robertx22.mine_and_slash.uncommon.capability.world.WorldMapCap;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAffectsStats;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatConversion;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatTransfer;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;

public class CommonStatUtils {
    public static void addCustomStats(EntityCap.UnitData data, Unit unit, int level) {
        for (StatModData stat : data.getCustomStats().stats.values()) {
            stat.applyStats(data, level);
        }
    }

    public static void addExactCustomStats(EntityCap.UnitData data) {
        for (ExactStatData stat : data.getCustomExactStats().stats.values()) {
            stat.applyStats(data);
        }
    }

    public static void addPotionStats(LivingEntity entity, EntityCap.UnitData data) {
        PlayerSpellCap.ISpellsCap cap = Load.spells(entity);
        for (EffectInstance instance : entity.func_70651_bq()) {
            if (!(instance.func_188419_a() instanceof IApplyStatPotion)) continue;
            IApplyStatPotion stat = (IApplyStatPotion)instance.func_188419_a();
            try {
                stat.applyStats(data, cap, instance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void CalcTraitsAndCoreStats(EntityCap.UnitData unit) {
        StatData statdata;
        Unit theunit = unit.getUnit();
        for (IPreCoreStat iPreCoreStat : Stats.allPreGenMapStatLists.get(IPreCoreStat.class)) {
            statdata = theunit.peekAtStat(iPreCoreStat.GUID());
            if (!statdata.isMoreThanZero()) continue;
            iPreCoreStat.addToCoreStats(unit, statdata);
        }
        for (ICoreStat iCoreStat : Stats.allPreGenMapStatLists.get(ICoreStat.class)) {
            statdata = theunit.peekAtStat(iCoreStat.GUID());
            if (!statdata.isMoreThanZero()) continue;
            iCoreStat.addToOtherStats(unit, statdata);
        }
        for (Trait trait : Stats.allPreGenMapStatLists.get(Trait.class)) {
            statdata = theunit.peekAtStat(trait.GUID());
            if (!statdata.isMoreThanZero()) continue;
            trait.TryAffectOtherStats(unit, statdata);
        }
        for (IAffectsStats iAffectsStats : Stats.allPreGenMapStatLists.get(IAffectsStats.class)) {
            statdata = theunit.peekAtStat(iAffectsStats.GUID());
            if (!statdata.isMoreThanZero()) continue;
            iAffectsStats.affectStats(unit, statdata);
        }
    }

    public static void CalcStatConversionsAndTransfers(Unit copy, Unit unit) {
        StatData statdata;
        for (IStatConversion iStatConversion : Stats.allPreGenMapStatLists.get(IStatConversion.class)) {
            statdata = copy.peekAtStat(iStatConversion.GUID());
            if (!statdata.isMoreThanZero()) continue;
            iStatConversion.convertStats(copy, unit, copy.getCreateStat(iStatConversion.GUID()));
        }
        for (IStatTransfer iStatTransfer : Stats.allPreGenMapStatLists.get(IStatTransfer.class)) {
            statdata = copy.peekAtStat(iStatTransfer.GUID());
            if (!statdata.isMoreThanZero()) continue;
            iStatTransfer.transferStats(copy, unit, copy.getCreateStat(iStatTransfer.GUID()));
        }
    }

    public static void AddMapAffixStats(WorldMapCap.IWorldMapData mapdata, Unit unit, int level, LivingEntity entity) {
        for (MapAffixData status : WorldUtils.getAllAffixesThatAffect(mapdata, entity)) {
            List<StatModData> datas = status.GetAllStats();
            for (StatModData statModData : datas) {
                StatData statData = unit.getCreateStat(statModData.getStatMod().GetBaseStat());
                if (statData == null) continue;
                statData.add(statModData, level);
            }
        }
    }
}

