/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.stat_calculation;

import com.robertx22.mine_and_slash.config.forge.ModConfig;
import com.robertx22.mine_and_slash.config.whole_mod_entity_configs.ModEntityConfig;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.stats.Stat;
import com.robertx22.mine_and_slash.database.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalPene;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalResist;
import com.robertx22.mine_and_slash.database.stats.types.generated.ElementalSpellDamage;
import com.robertx22.mine_and_slash.database.stats.types.offense.CriticalDamage;
import com.robertx22.mine_and_slash.database.stats.types.offense.CriticalHit;
import com.robertx22.mine_and_slash.database.stats.types.offense.PhysicalDamage;
import com.robertx22.mine_and_slash.database.stats.types.resources.Health;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.StatData;
import com.robertx22.mine_and_slash.saveclasses.Unit;
import com.robertx22.mine_and_slash.uncommon.capability.entity.EntityCap;
import java.util.stream.Collectors;
import net.minecraft.entity.LivingEntity;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class MobStatUtils {
    static int spelldmg = 12;

    public static void increaseMobStatsPerTier(EntityCap.UnitData mobdata, Unit unit) {
        for (StatData data : unit.getStats().values().stream().filter(x -> !x.GetStat().IsPercent()).collect(Collectors.toList())) {
            data.multiplyFlat(mobdata.getMapTier().mob_stat_multi);
        }
    }

    public static void addAffixStats(EntityCap.UnitData data) {
        if (data.getUnit().getPrefix() != null) {
            data.getUnit().getPrefix().applyStats(data);
        }
        if (data.getUnit().getSuffix() != null) {
            data.getUnit().getSuffix().applyStats(data);
        }
    }

    public static void increaseMobStatsPerLevel(EntityCap.UnitData mobdata) {
        float lvlMulti = 1.0f + ((Double)ModConfig.INSTANCE.Server.MOB_STRENGTH_PER_LEVEL_MULTI.get()).floatValue() * (float)mobdata.getLevel();
        for (StatData data : mobdata.getUnit().getStats().values().stream().filter(x -> !x.GetStat().IsPercent()).collect(Collectors.toList())) {
            data.multiplyFlat(lvlMulti);
        }
    }

    public static void worldMultiplierStats(World world, Unit unit) {
        for (StatData stat : unit.getStats().values()) {
            stat.multiplyFlat(SlashRegistry.getDimensionConfig((IWorld)world).MOB_STRENGTH_MULTIPLIER);
            if (!stat.getId().equals(Health.GUID)) continue;
            stat.multiplyFlat(SlashRegistry.getDimensionConfig((IWorld)world).MOB_HP_MULTIPLIER);
        }
    }

    public static void modifyMobStatsByConfig(LivingEntity entity, EntityCap.UnitData unitdata) {
        Unit unit = unitdata.getUnit();
        ModEntityConfig config = SlashRegistry.getEntityConfig(entity, unitdata);
        for (StatData data : unit.getStats().values()) {
            Stat stat = data.GetStat();
            if (stat instanceof PhysicalDamage || stat instanceof ElementalSpellDamage || stat instanceof CriticalDamage || stat instanceof CriticalHit) {
                data.multiplyFlat(config.DMG_MULTI);
                continue;
            }
            if (data.getId().equals(Health.GUID)) {
                data.multiplyFlat(config.HP_MULTI);
                continue;
            }
            data.multiplyFlat(config.STAT_MULTI);
        }
    }

    public static void AddMobcStats(EntityCap.UnitData unitdata, int level) {
        MobRarity rar = (MobRarity)Rarities.Mobs.get(unitdata.getRarity());
        Unit unit = unitdata.getUnit();
        unit.getCreateStat(Armor.GUID).addFlat(Armor.getInstance().AverageStat() * rar.StatMultiplier(), level);
        unit.getCreateStat(CriticalHit.GUID).addFlat(5.0f * rar.DamageMultiplier());
        unit.getCreateStat(CriticalDamage.GUID).addFlat(5.0f * rar.DamageMultiplier());
        ElementalResist.MAP.getList().forEach(x -> unit.getCreateStat((Stat)x).addFlat(5.0f * rar.StatMultiplier(), level));
        ElementalSpellDamage.MAP.getList().forEach(x -> unit.getCreateStat((Stat)x).addFlat((float)spelldmg * rar.DamageMultiplier(), level));
        ElementalPene.MAP.getList().forEach(x -> unit.getCreateStat((Stat)x).addFlat(4.0f * rar.DamageMultiplier(), level));
    }
}

