/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.uncommon.utilityclasses.TeamUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFinder {
    static boolean isTamed(LivingEntity x) {
        if (x instanceof TameableEntity) {
            TameableEntity tame = (TameableEntity)x;
            return tame.func_70909_n();
        }
        return false;
    }

    private static boolean isPlayer(Entity en) {
        return en instanceof PlayerEntity;
    }

    public static <T extends LivingEntity> Setup<T> start(LivingEntity caster, Class<T> entityType, Vec3d pos) {
        Setup<T> setup = new Setup<T>(caster, entityType, pos);
        return setup;
    }

    public static class Setup<T extends LivingEntity> {
        Class<T> entityType;
        Finder finder = Finder.RADIUS;
        SearchFor searchFor = SearchFor.ENEMIES;
        LivingEntity caster;
        boolean forceExcludeCaster = false;
        World world;
        Vec3d pos;
        double radius = 1.0;
        double horizontal = 1.0;
        double vertical = 1.0;
        boolean addTestParticles = false;
        List<Predicate<T>> predicates = new ArrayList<Predicate<T>>();
        boolean setRadius = false;
        double distanceToSearch = 10.0;

        public Setup(LivingEntity caster, Class<T> entityType, Vec3d pos) {
            this.entityType = entityType;
            this.caster = caster;
            this.world = caster.field_70170_p;
            this.pos = pos;
        }

        public boolean isCasterPlayer() {
            return this.caster instanceof PlayerEntity;
        }

        public List<T> build() {
            Objects.requireNonNull(this.caster, "Caster can't be null");
            Objects.requireNonNull(this.caster, "Blockpos can't be null");
            Objects.requireNonNull(this.caster, "World can't be null");
            List list = this.finder.getEntities(this);
            list.removeIf(x -> x == null);
            for (Predicate predicate : this.predicates) {
                list.removeIf(y -> !predicate.test(y));
            }
            list = this.searchFor.getMatchingEntities(list, this);
            if (this.forceExcludeCaster || !this.searchFor.includesCaster()) {
                list.removeIf(x -> x == this.caster);
            }
            list.removeIf(x -> !x.func_70089_S());
            return list;
        }

        public Setup<T> addPredicate(Predicate<T> p) {
            this.predicates.add(p);
            return this;
        }

        public Setup<T> finder(Finder f) {
            this.finder = f;
            return this;
        }

        public Setup<T> searchFor(SearchFor f) {
            this.searchFor = f;
            return this;
        }

        public Setup<T> distance(double distance) {
            this.distanceToSearch = distance;
            return this;
        }

        public Setup<T> height(double rad) {
            this.vertical = rad;
            return this;
        }

        public Setup<T> radius(double rad) {
            this.radius = rad;
            this.horizontal = rad;
            this.vertical = rad;
            return this;
        }

        public Setup<T> excludeCaster(boolean bool) {
            this.forceExcludeCaster = bool;
            return this;
        }
    }

    public static enum Finder {
        RADIUS{

            @Override
            public <T extends Entity> List<T> getEntities(Setup setup) {
                double x = setup.pos.func_82615_a();
                double y = setup.pos.func_82617_b();
                double z = setup.pos.func_82616_c();
                double hori = setup.horizontal;
                double verti = setup.vertical;
                AxisAlignedBB aabb = new AxisAlignedBB(x - hori, y - verti, z - hori, x + hori, y + verti, z + hori);
                if (setup.addTestParticles) {
                    Utilities.spawnParticlesForTesting(aabb, setup.world);
                }
                List entityList = setup.world.func_217357_a(setup.entityType, aabb);
                return entityList;
            }
        }
        ,
        IN_FRONT{

            @Override
            public <T extends Entity> List<T> getEntities(Setup setup) {
                LivingEntity entity = setup.caster;
                double distance = setup.distanceToSearch;
                double horizontal = setup.horizontal;
                double vertical = setup.vertical;
                double x = entity.field_70165_t;
                double y = entity.field_70163_u;
                double z = entity.field_70161_v;
                Vec3d l = Utilities.getEndOfLook(entity, distance);
                double minX = x < l.field_72450_a ? x : l.field_72450_a;
                double minY = y < l.field_72448_b ? y : l.field_72448_b;
                double minZ = z < l.field_72449_c ? z : l.field_72449_c;
                double maxX = x > l.field_72450_a ? x : l.field_72450_a;
                double maxY = y > l.field_72448_b ? y : l.field_72448_b;
                double maxZ = z > l.field_72449_c ? z : l.field_72449_c;
                AxisAlignedBB aabb = new AxisAlignedBB(minX - horizontal, minY - vertical, minZ - horizontal, maxX + horizontal, maxY + vertical, maxZ + horizontal);
                if (setup.addTestParticles) {
                    Utilities.spawnParticlesForTesting(aabb, setup.world);
                }
                List entityList = entity.field_70170_p.func_217357_a(setup.entityType, aabb);
                entityList.removeIf(e -> e == entity);
                return entityList;
            }
        };


        public abstract <T extends Entity> List<T> getEntities(Setup var1);
    }

    public static enum SearchFor {
        ALLIES{

            @Override
            public <T extends LivingEntity> List<T> getMatchingEntities(List<T> list, Setup setup) {
                return list.stream().filter(x -> {
                    if (setup.isCasterPlayer()) {
                        if (EntityFinder.isPlayer((Entity)x)) {
                            if (x.field_70170_p.field_72995_K) {
                                return true;
                            }
                            if (setup.caster.func_70028_i((Entity)x)) {
                                return true;
                            }
                            return TeamUtils.areOnSameTeam((PlayerEntity)((ServerPlayerEntity)setup.caster), (PlayerEntity)((ServerPlayerEntity)x));
                        }
                        return EntityFinder.isTamed(x);
                    }
                    return !(x instanceof PlayerEntity) && !EntityFinder.isTamed(x);
                }).collect(Collectors.toList());
            }

            @Override
            public boolean includesCaster() {
                return true;
            }
        }
        ,
        ENEMIES{

            @Override
            public <T extends LivingEntity> List<T> getMatchingEntities(List<T> list, Setup setup) {
                return list.stream().filter(x -> {
                    if (setup.isCasterPlayer()) {
                        if (EntityFinder.isPlayer((Entity)x)) {
                            if (x.field_70170_p.field_72995_K) {
                                return false;
                            }
                            return !TeamUtils.areOnSameTeam((PlayerEntity)((ServerPlayerEntity)setup.caster), (PlayerEntity)((ServerPlayerEntity)x));
                        }
                        return !EntityFinder.isTamed(x);
                    }
                    return EntityFinder.isPlayer((Entity)x);
                }).collect(Collectors.toList());
            }

            @Override
            public boolean includesCaster() {
                return false;
            }
        }
        ,
        ALL{

            @Override
            public <T extends LivingEntity> List<T> getMatchingEntities(List<T> list, Setup setup) {
                return list;
            }

            @Override
            public boolean includesCaster() {
                return true;
            }
        };


        public abstract <T extends LivingEntity> List<T> getMatchingEntities(List<T> var1, Setup var2);

        public abstract boolean includesCaster();
    }
}

