/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import net.minecraft.entity.Entity;
import net.minecraft.entity.INPC;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;

public class EntityTypeUtils {
    public static EntityType getType(LivingEntity entity) {
        if (EntityTypeUtils.isMob((Entity)entity)) {
            return EntityType.MOB;
        }
        if (EntityTypeUtils.isAnimal((Entity)entity)) {
            return EntityType.ANIMAL;
        }
        if (EntityTypeUtils.isNPC((Entity)entity)) {
            return EntityType.NPC;
        }
        if (entity instanceof PlayerEntity) {
            return EntityType.PLAYER;
        }
        return EntityType.OTHER;
    }

    public static boolean isMob(Entity en) {
        return en instanceof IMob;
    }

    public static boolean isAnimal(Entity en) {
        return en instanceof AnimalEntity;
    }

    public static boolean isNPC(Entity en) {
        return en instanceof INPC;
    }

    public static enum EntityType {
        MOB(Items.field_196177_df),
        PLAYER(null),
        ANIMAL(Items.field_151015_O),
        NPC(Items.field_151166_bC),
        OTHER(null);

        public Item itemDenotingType;

        private EntityType(Item item) {
            this.itemDenotingType = item;
        }

        public boolean showsItem() {
            return this.itemDenotingType != null;
        }
    }
}

