/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipInfo;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiUtils {
    public static void renderScaledText(int x, int y, double scale, String text, TextFormatting format) {
        double antiScale = 1.0 / scale;
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        double textWidthMinus = (double)(Minecraft.func_71410_x().field_71466_p.func_78256_a(text) / 2) * scale;
        Minecraft.func_71410_x().field_71466_p.getClass();
        double textHeightMinus = 9.0 * scale / 2.0;
        float xp = (float)((double)x - textWidthMinus);
        float yp = (float)((double)y - textHeightMinus);
        float xf = (float)((double)xp * antiScale);
        float yf = (float)((double)yp * antiScale);
        Minecraft.func_71410_x().field_71466_p.func_175063_a(text, xf, yf, format.func_211163_e().intValue());
        RenderSystem.scaled((double)antiScale, (double)antiScale, (double)antiScale);
    }

    public static void renderTooltip(List<ITextComponent> tooltip, int mouseX, int mouseY) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        if (screen != null) {
            TooltipInfo info = new TooltipInfo((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            screen.renderTooltip(TooltipUtils.compsToStrings(tooltip), mouseX, mouseY, Minecraft.func_71410_x().field_71466_p);
        }
    }

    public static void renderTooltip(ItemStack stack, int mouseX, int mouseY) {
        Screen screen = Minecraft.func_71410_x().field_71462_r;
        List tooltip = stack.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        if (screen != null) {
            TooltipInfo info = new TooltipInfo((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
            screen.renderTooltip(TooltipUtils.compsToStrings(tooltip), mouseX, mouseY, Minecraft.func_71410_x().field_71466_p);
        }
    }

    public static boolean isInRectPoints(Point guiPos, Point size, Point mousePos) {
        return GuiUtils.isInRect(guiPos.x, guiPos.y, size.x, size.y, mousePos.x, mousePos.y);
    }

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public static List<PointF> generateCurve(PointF pFrom, PointF pTo, float pRadius, float pMinDistance, boolean shortest) {
        boolean side2;
        ArrayList<PointF> pOutPut = new ArrayList<PointF>();
        PointF mPoint = new PointF(pFrom.x + pTo.x, pFrom.y + pTo.y);
        mPoint.x /= 2.0f;
        mPoint.y /= 2.0f;
        float xDiff = pTo.x - pFrom.x;
        float yDiff = pTo.y - pFrom.y;
        float distance = (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
        while (pRadius * 2.0f < distance) {
            pRadius += 1.0f;
        }
        float factor = (float)Math.sqrt(pRadius * pRadius / ((pTo.x - pFrom.x) * (pTo.x - pFrom.x) + (pTo.y - pFrom.y) * (pTo.y - pFrom.y)) - 0.25f);
        PointF circleMiddlePoint = new PointF(0.0f, 0.0f);
        float middleDistance1 = 0.5f * (pFrom.x + pTo.x) + factor * (pTo.y - pFrom.y) + 0.5f * (pFrom.y + pTo.y) + factor * (pFrom.x - pTo.x);
        float middleDistance2 = 0.5f * (pFrom.x + pTo.x) - factor * (pTo.y - pFrom.y) + 0.5f * (pFrom.y + pTo.y) - factor * (pFrom.x - pTo.x);
        boolean bl = side2 = middleDistance1 < middleDistance2;
        if (side2) {
            circleMiddlePoint.x = 0.5f * (pFrom.x + pTo.x) + factor * (pTo.y - pFrom.y);
            circleMiddlePoint.y = 0.5f * (pFrom.y + pTo.y) + factor * (pFrom.x - pTo.x);
        } else {
            circleMiddlePoint.x = 0.5f * (pFrom.x + pTo.x) - factor * (pTo.y - pFrom.y);
            circleMiddlePoint.y = 0.5f * (pFrom.y + pTo.y) - factor * (pFrom.x - pTo.x);
        }
        float angle1 = (float)Math.atan2(pFrom.y - circleMiddlePoint.y, pFrom.x - circleMiddlePoint.x);
        float angle2 = (float)Math.atan2(pTo.y - circleMiddlePoint.y, pTo.x - circleMiddlePoint.x);
        float step = pMinDistance / pRadius;
        if (angle1 > angle2) {
            float temp = angle1;
            angle1 = angle2;
            angle2 = temp;
        }
        boolean flipped = false;
        if (!shortest && (double)(angle2 - angle1) < Math.PI) {
            float temp = angle1;
            angle1 = angle2;
            angle2 = temp;
            angle2 = (float)((double)angle2 + Math.PI * 2);
            flipped = true;
        }
        for (float f = angle1; f < angle2; f += step) {
            PointF p = new PointF((float)Math.cos(f) * pRadius + circleMiddlePoint.x, (float)Math.sin(f) * pRadius + circleMiddlePoint.y);
            pOutPut.add(p);
        }
        if (flipped ^ side2) {
            pOutPut.add(pFrom);
        } else {
            pOutPut.add(pTo);
        }
        return pOutPut;
    }

    public static class PointF {
        public float x;
        public float y;

        public PointF(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + "," + this.y + ")";
        }
    }
}

