/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.database.bosses.base.Boss;
import com.robertx22.mine_and_slash.database.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.rarities.mobs.EpicMob;
import com.robertx22.mine_and_slash.database.rarities.mobs.LegendaryMob;
import com.robertx22.mine_and_slash.database.rarities.mobs.RareMob;
import com.robertx22.mine_and_slash.new_content.registry.MobPotionEffects;
import com.robertx22.mine_and_slash.onevent.entity.OnMobSpawn;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MobSpawnUtils {
    public static void announceEvent(World world, ITextComponent comp) {
        world.func_217369_A().forEach(x -> x.func_145747_a(comp));
    }

    public static <T extends MobEntity> void summonMinions(EntityType<T> type, int amount, IWorld world, BlockPos p) {
        for (int i = 0; i < amount; ++i) {
            MobSpawnUtils.summonMinion(type, world, p);
        }
    }

    public static <T extends MobEntity> T summonBoss(EntityType<T> type, IWorld world, BlockPos p, Boss boss) {
        Vec3d vec = new Vec3d((Vec3i)p);
        vec = vec.func_72441_c(0.5, 0.0, 0.5);
        MobEntity bossEntity = (MobEntity)type.func_200721_a(world.func_201672_e());
        bossEntity.func_213386_a(world, world.func_175649_E(p), SpawnReason.REINFORCEMENT, null, null);
        bossEntity.func_70107_b(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c());
        OnMobSpawn.setupNewMobOnSpawn((LivingEntity)bossEntity);
        Load.boss((ICapabilityProvider)bossEntity).setBoss(boss);
        Load.Unit((ICapabilityProvider)bossEntity).setRarity(-2);
        world.func_217376_c((Entity)bossEntity);
        return (T)bossEntity;
    }

    public static <T extends MobEntity> T summonMinion(EntityType<T> type, IWorld world, BlockPos p) {
        Vec3d vec = new Vec3d((Vec3i)p);
        vec = vec.func_72441_c(0.5, 0.0, 0.5);
        MobEntity minion = (MobEntity)type.func_200721_a(world.func_201672_e());
        minion.func_213386_a(world, world.func_175649_E(p), SpawnReason.REINFORCEMENT, null, null);
        minion.func_70107_b(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c());
        OnMobSpawn.setupNewMobOnSpawn((LivingEntity)minion);
        world.func_217376_c((Entity)minion);
        return (T)minion;
    }

    public static <T extends MobEntity> T summon(EntityType<T> type, IWorld world, BlockPos p, MobRarity rarity, boolean addPotion, Boss boss) {
        Vec3d vec = new Vec3d((Vec3i)p);
        vec = vec.func_72441_c(0.5, 0.0, 0.5);
        MobEntity mob = (MobEntity)type.func_200721_a(world.func_201672_e());
        mob.func_213386_a(world, world.func_175649_E(p), SpawnReason.REINFORCEMENT, null, null);
        mob.func_70107_b(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c());
        OnMobSpawn.setupNewMobOnSpawn((LivingEntity)mob);
        Load.Unit((ICapabilityProvider)mob).setRarity(rarity.Rank());
        if (boss != null) {
            Load.boss((ICapabilityProvider)mob).setBoss(SlashRegistry.Bosses().random());
            Load.Unit((ICapabilityProvider)mob).setRarity(-2);
        }
        if (addPotion) {
            mob.func_195064_c(new EffectInstance(MobPotionEffects.getRandom(), Integer.MAX_VALUE, RandomUtils.RandomRange(1, 3)));
        }
        world.func_217376_c((Entity)mob);
        return (T)mob;
    }

    public static <T extends MobEntity> T summonElite(EntityType<T> type, IWorld world, BlockPos p) {
        Vec3d vec = new Vec3d((Vec3i)p);
        vec = vec.func_72441_c(0.5, 0.0, 0.5);
        MobEntity elite = (MobEntity)type.func_200721_a(world.func_201672_e());
        elite.func_213386_a(world, world.func_175649_E(p), SpawnReason.REINFORCEMENT, null, null);
        elite.func_70107_b(vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c());
        OnMobSpawn.setupNewMobOnSpawn((LivingEntity)elite);
        Load.Unit((ICapabilityProvider)elite).setRarity(RandomUtils.weightedRandom(Arrays.asList(LegendaryMob.getInstance(), EpicMob.getInstance(), RareMob.getInstance())).Rank());
        if (RandomUtils.roll(25)) {
            elite.func_195064_c(new EffectInstance(MobPotionEffects.getRandom(), Integer.MAX_VALUE, RandomUtils.RandomRange(1, 3)));
        }
        world.func_217376_c((Entity)elite);
        return (T)elite;
    }

    public static BlockPos randomPosNearPlayer(World world) {
        BlockPos pos = ((PlayerEntity)world.func_217369_A().get(0)).func_180425_c();
        pos = new BlockPos(pos.func_177958_n() + RandomUtils.RandomRange(-50, 50), pos.func_177956_o(), pos.func_177952_p() + RandomUtils.RandomRange(-50, 50));
        pos = WorldUtils.getSurface((IWorld)world, pos).func_177984_a();
        return pos;
    }
}

