/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEffect;
import java.text.DecimalFormat;

public class NumberUtils {
    static int MILLS = 1000000;
    static int THOUSANDS = 1000;
    static DecimalFormat format = new DecimalFormat();

    private static String formatNumber(int number, int divided, String letter) {
        int amount = number / divided;
        int remaining = number - amount * divided;
        if (remaining > 0) {
            remaining /= divided / 10;
        }
        String firstRemaining = (remaining + "").substring(0, 1);
        return amount + "." + firstRemaining + letter;
    }

    public static String formatNumber(float number) {
        return NumberUtils.formatNumber((int)number);
    }

    public static String trimFloat(float num) {
        if (num < 10.0f) {
            return format.format(num);
        }
        return (int)num + "";
    }

    public static String formatNumber(int number) {
        if (Math.abs(number / MILLS) >= 1) {
            return NumberUtils.formatNumber(number, MILLS, "m");
        }
        if (Math.abs(number / THOUSANDS) >= 1) {
            return NumberUtils.formatNumber(number, THOUSANDS, "k");
        }
        return number + "";
    }

    public static String formatDamageNumber(DamageEffect data, int val) {
        String num = NumberUtils.formatNumber(val);
        if (data.crit) {
            num = num + "!";
        }
        return num;
    }

    static {
        format = new DecimalFormat();
        format.setMaximumFractionDigits(1);
    }
}

