/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.potion_effects.all.TeleportProtection;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityUtils;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class PlayerUtils {
    private static final ITeleporter PORTALLESS = new ITeleporter(){

        public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
            return repositionEntity.apply(false);
        }
    };

    public static BlockPos getBedLocation(PlayerEntity player) {
        Optional opt;
        BlockPos pos = null;
        if (pos == null && (opt = player.func_213374_dv()).isPresent()) {
            pos = (BlockPos)opt.get();
        }
        if (pos == null) {
            pos = player.getBedLocation(player.field_70170_p.func_201675_m().func_186058_p());
        }
        if (pos == null) {
            pos = player.func_180470_cg();
        }
        return pos;
    }

    public static void giveItem(ItemStack stack, PlayerEntity player) {
        if (!player.func_191521_c(stack)) {
            player.func_70099_a(stack, 1.0f);
        }
        player.field_71071_by.func_70296_d();
    }

    public static void sendPlayersMSGofStructureSpawnTEST(BlockPos pos, String name) {
        if (MMORPG.RUN_DEV_TOOLS) {
            for (ServerPlayerEntity player : MapManager.getServer().func_184103_al().func_181057_v()) {
                player.func_145747_a((ITextComponent)new StringTextComponent(name + " Structure spawned at : " + pos.toString()));
            }
        }
    }

    public static Entity changeDimension(ServerPlayerEntity player, DimensionType destination, BlockPos pos) {
        System.out.println("Teleporting player to " + pos.toString() + " with mine and slash. ");
        MapManager.getWorld(destination).func_217349_x(pos);
        player.func_213293_j(0.0, 0.0, 0.0);
        player = (ServerPlayerEntity)player.changeDimension(destination, PORTALLESS);
        player.func_195064_c(new EffectInstance((Effect)TeleportProtection.INSTANCE, 200));
        EntityUtils.setLoc((LivingEntity)player, new Vec3d((Vec3i)pos), player.field_70177_z, player.field_70125_A);
        return player;
    }

    @Nullable
    public static PlayerEntity nearestPlayer(ServerWorld world, LivingEntity entity) {
        Optional<ServerPlayerEntity> player = world.func_217369_A().stream().min(Comparator.comparingDouble(arg_0 -> ((LivingEntity)entity).func_70068_e(arg_0)));
        if (player.isPresent()) {
            return (PlayerEntity)player.get();
        }
        return null;
    }

    public static CompoundNBT getPersistentNBT(PlayerEntity player) {
        CompoundNBT nbt = null;
        try {
            CompoundNBT basenbt = player.getPersistentData();
            if (basenbt != null) {
                nbt = basenbt;
            }
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
        }
        catch (Exception e) {
            nbt = new CompoundNBT();
            e.printStackTrace();
        }
        return nbt;
    }

    public static void setPestistentNBT(PlayerEntity player, CompoundNBT nbt) {
        player.getPersistentData().func_218657_a("PlayerPersisted", (INBT)nbt);
    }
}

