/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.uncommon.interfaces.IWeighted;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.util.math.MathHelper;

public class RandomUtils {
    private static Random ran = new Random();

    public static int RandomRange(int min, int max) {
        return RandomUtils.RandomRange(min, max, ran);
    }

    public static float RandomRange(float min, float max) {
        return RandomUtils.RandomRange((int)min, (int)max, ran);
    }

    public static int RandomRange(int min, int max, Random rand) {
        try {
            if (max < 1) {
                return 0;
            }
            if (min > max) {
                return min;
            }
            if (min == max) {
                return min;
            }
            int result = rand.nextInt(max - min + 1);
            return MathHelper.func_76125_a((int)(result + min), (int)min, (int)max);
        }
        catch (Exception e) {
            System.out.println("min " + min + " max " + max);
            e.printStackTrace();
            return 0;
        }
    }

    public static <T> T randomFromList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int random = RandomUtils.RandomRange(0, list.size() - 1);
        return list.get(random);
    }

    public static <T> T randomFromList(List<T> list, Random rand) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        int random = RandomUtils.RandomRange(0, list.size() - 1, rand);
        return list.get(random);
    }

    private static <OLD, NEW> List<NEW> CollectionToList(Collection<OLD> coll) {
        ArrayList<OLD> list = new ArrayList<OLD>();
        for (OLD old : coll) {
            list.add(old);
        }
        return list;
    }

    public static boolean roll(double chance, Random rand) {
        double ranNum = rand.nextDouble() * 100.0;
        return chance > ranNum;
    }

    public static boolean roll(double chance) {
        double ranNum = ran.nextDouble() * 100.0;
        return chance > ranNum;
    }

    public static boolean roll(int chance) {
        double ranNum = ran.nextDouble() * 100.0;
        return (double)chance > ranNum;
    }

    public static boolean roll(float chance) {
        double ranNum = ran.nextDouble() * 100.0;
        return (double)chance >= ranNum;
    }

    public static <T extends IWeighted> List<T> uniqueWightedRandoms(Collection<T> coll, int amount) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        if (coll.size() <= amount) {
            return new ArrayList<T>(coll);
        }
        ArrayList<IWeighted> list = new ArrayList<IWeighted>();
        for (int tries = 0; list.size() < amount && tries < 15; ++tries) {
            IWeighted t = RandomUtils.WeightedRandom(RandomUtils.CollectionToList(coll), Math.random());
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T extends IWeighted> T weightedRandom(Collection<T> coll) {
        return RandomUtils.weightedRandom(coll, Math.random());
    }

    public static <T extends IWeighted> T weightedRandom(Collection<T> coll, double nextDouble) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        return (T)RandomUtils.WeightedRandom(RandomUtils.CollectionToList(coll), nextDouble);
    }

    private static IWeighted WeightedRandom(List<IWeighted> lootTable, double nextDouble) {
        double value = (double)RandomUtils.Total(lootTable) * nextDouble;
        double weight = 0.0;
        for (IWeighted item : lootTable) {
            if (!(value < (weight += (double)item.Weight()))) continue;
            return item;
        }
        return null;
    }

    private static int Total(List<IWeighted> list) {
        int total = 0;
        for (IWeighted w : list) {
            total += w.Weight();
        }
        return total;
    }
}

