/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.database.rarities.GearRarity;
import com.robertx22.mine_and_slash.db_lists.Rarities;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.items.SimpleMatItem;
import com.robertx22.mine_and_slash.items.ores.ItemOre;
import com.robertx22.mine_and_slash.new_content.trader.ISellPrice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;

public class RecipeUtils {
    private static HashMap<Item, Integer> ITEM_COMMONS = new HashMap();

    public static ItemStack getSalvageStack(Item item) {
        return ISellPrice.getHighestRarityStackFromCommons(RecipeUtils.getCommonOresNeededToCraftItem(item));
    }

    public static int getCommonOresNeededToCraftItem(Item item) {
        if (!ITEM_COMMONS.containsKey(item)) {
            int least = Integer.MAX_VALUE;
            boolean has = false;
            for (IRecipe r : RecipeUtils.getRecipesForThisItem(item)) {
                int commons = RecipeUtils.getCommonOresNeededToCraftItemUsingRecipe(r);
                if (commons >= least) continue;
                least = commons;
                has = true;
            }
            if (!has) {
                least = 0;
            }
            ITEM_COMMONS.put(item, least);
        }
        return ITEM_COMMONS.get(item);
    }

    public static int getCommonOresNeededToCraftItemUsingRecipe(IRecipe recipe, Item item) {
        float commons = RecipeUtils.getCommonOresNeededToCraftItemUsingRecipe(recipe);
        ArrayList matIngredients = new ArrayList();
        NonNullList ingredients = recipe.func_192400_c();
        ingredients.stream().forEach(x -> {
            for (ItemStack stack : x.func_193365_a()) {
                if (!(stack.func_77973_b() instanceof SimpleMatItem)) continue;
                matIngredients.add(stack.func_77973_b());
            }
        });
        for (Item m : matIngredients) {
            List<IRecipe> recipes = RecipeUtils.getRecipesForThisItem(m);
            if (recipes.size() == 1) {
                IRecipe matRecipe = recipes.get(0);
                commons += (float)RecipeUtils.getCommonOresNeededToCraftItemUsingRecipe(matRecipe);
                continue;
            }
            commons = 0.0f;
        }
        return (int)commons;
    }

    public static int getCommonOresNeededToCraftItemUsingRecipe(IRecipe recipe) {
        float commons = 0.0f;
        for (GearRarity rar : Rarities.Gears.getNormalRarities()) {
            Item ore = ItemOre.ItemOres.get(rar.Rank());
            NonNullList ingredients = recipe.func_192400_c();
            ArrayList matIngredients = new ArrayList();
            List oreIngredients = ingredients.stream().filter(x -> x.test(new ItemStack((IItemProvider)ore))).collect(Collectors.toList());
            commons += (float)ISellPrice.rarityOresToCommons(rar, oreIngredients.size());
        }
        return (int)commons;
    }

    public static List<IRecipe> getRecipesForThisItem(Item item) {
        List reg = MapManager.getServer().func_199529_aN().func_199510_b().stream().filter(x -> x.func_222127_g().equals(IRecipeType.field_222149_a)).collect(Collectors.toList());
        List<IRecipe> recipes = reg.stream().filter(x -> x.func_77571_b().func_77973_b().equals(item)).collect(Collectors.toList());
        return recipes;
    }
}

