/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ServerOnly;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public final class Utilities {
    @Nullable
    public static LivingEntity getLivingEntityByUUID(World world, @Nullable UUID id) {
        Entity en = Utilities.getEntityByUUID(world, id);
        if (en instanceof LivingEntity) {
            return (LivingEntity)en;
        }
        return null;
    }

    @Nullable
    public static Entity getEntityByUUID(World world, @Nullable UUID id) {
        if (id == null) {
            return null;
        }
        if (world.field_72995_K) {
            return ClientOnly.getEntityByUUID(world, id);
        }
        return ServerOnly.getEntityByUUID(world, id);
    }

    public static Vec3d getEndOfLook(LivingEntity entity, double distance) {
        return entity.func_174824_e(0.5f).func_178787_e(entity.func_70040_Z().func_186678_a(distance));
    }

    public static void spawnParticlesForTesting(AxisAlignedBB aabb, World world) {
        if (!world.field_72995_K) {
            for (double x = aabb.field_72340_a; x < aabb.field_72336_d; x += (double)0.3f) {
                for (double y = aabb.field_72338_b; y < aabb.field_72337_e; y += 1.0) {
                    for (double z = aabb.field_72339_c; z < aabb.field_72334_f; z += (double)0.3f) {
                        for (int i = 0; i < 1; ++i) {
                            ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197632_y, x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
        }
    }

    public static double getPlayerEyesPos(LivingEntity player) {
        return player.func_174813_aQ().field_72338_b + (double)player.func_70047_e();
    }
}

