/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.uncommon.utilityclasses;

import com.robertx22.mine_and_slash.config.dimension_configs.DimensionConfig;
import com.robertx22.mine_and_slash.database.world_providers.base.BaseDungeonDimension;
import com.robertx22.mine_and_slash.database.world_providers.base.IWP;
import com.robertx22.mine_and_slash.registry.SlashRegistry;
import com.robertx22.mine_and_slash.saveclasses.item_classes.MapItemData;
import com.robertx22.mine_and_slash.saveclasses.mapitem.MapAffixData;
import com.robertx22.mine_and_slash.uncommon.capability.world.WorldMapCap;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class WorldUtils {
    public static void spawnEntity(World world, Entity entity) {
        world.func_217376_c(entity);
    }

    public static boolean isNearSurface(BlockPos pos, World world, int buffer) {
        BlockPos surface = WorldUtils.getSurface((IWorld)world, pos);
        return pos.func_177956_o() > surface.func_177956_o() - buffer;
    }

    public static List<MapAffixData> getAllAffixesThatAffect(WorldMapCap.IWorldMapData data, LivingEntity entity) {
        ArrayList<MapAffixData> list = new ArrayList<MapAffixData>();
        if (data != null) {
            list.addAll(MapItemData.getAllAffixesThatAffect(data.getMap((BlockPos)entity.func_180425_c(), (IWorld)entity.field_70170_p).affixes, entity));
        }
        list.addAll(MapItemData.getAllAffixesThatAffect(WorldUtils.getAllMapAffixes(entity.field_70170_p), entity));
        return list;
    }

    public static List<MapAffixData> getAllMapAffixes(World world) {
        ArrayList<MapAffixData> list = new ArrayList<MapAffixData>();
        if (WorldUtils.isMapWorldClass((IWorld)world)) {
            IWP iwp = (IWP)world.func_201675_m();
            list.addAll(iwp.getMapAffixes());
        }
        return list;
    }

    public static BlockPos getPosByLevel(World world, int lvl) {
        DimensionConfig config = SlashRegistry.getDimensionConfig((IWorld)world);
        BlockPos pos = LevelUtils.getAreaPosOfLevel(world, lvl, config);
        if ((pos = WorldUtils.getSurface((IWorld)world, pos).func_177981_b(2)).func_177956_o() > world.func_217301_I()) {
            pos = new BlockPos(pos.func_177958_n(), world.func_217301_I() - 1, pos.func_177952_p());
        }
        return pos;
    }

    public static BlockPos getSurfaceCenterOfChunk(IWorld world, BlockPos pos) {
        int x = world.func_217349_x((BlockPos)pos).func_76632_l().field_77276_a + 8;
        int z = world.func_217349_x((BlockPos)pos).func_76632_l().field_77275_b + 8;
        pos = WorldUtils.furtherby8(pos);
        pos = WorldUtils.getSurface(world, pos);
        return pos;
    }

    public static BlockPos furtherby8(BlockPos pos) {
        int x = 0;
        int z = 0;
        x = pos.func_177958_n() > 0 ? pos.func_177958_n() + 8 : pos.func_177958_n() - 8;
        z = pos.func_177952_p() > 0 ? pos.func_177952_p() + 8 : pos.func_177952_p() - 8;
        pos = new BlockPos(x, pos.func_177956_o(), z);
        return pos;
    }

    public static boolean surfaceIsWater(IWorld world, BlockPos pos) {
        BlockPos surface = WorldUtils.getSurface(world, pos);
        for (BlockPos x : Arrays.asList(surface.func_177984_a(), surface.func_177981_b(2), surface.func_177977_b(), surface.func_177979_c(2), surface)) {
            if (world.func_180495_p(x).func_185904_a() != Material.field_151586_h) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getSurface(IWorld world, BlockPos pos) {
        pos = new BlockPos(pos.func_177958_n(), world.func_181545_F(), pos.func_177952_p());
        boolean goingDown = world.func_175623_d(pos);
        while (world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c() instanceof LeavesBlock) {
            if (goingDown) {
                pos = pos.func_177977_b();
                continue;
            }
            pos = pos.func_177984_a();
        }
        while (!world.func_175623_d(pos.func_177984_a())) {
            pos = pos.func_177984_a();
        }
        return pos.func_177984_a();
    }

    public static boolean isMapWorld(IWorld world) {
        if (world == null) {
            return false;
        }
        if (WorldUtils.isMapWorldClass(world)) {
            return true;
        }
        return SlashRegistry.getDimensionConfig(world).isMapWorld();
    }

    public static boolean isMapWorldClass(IWorld world) {
        if (world == null) {
            return false;
        }
        return world.func_201675_m() instanceof BaseDungeonDimension;
    }

    public static IWP getIWP(IWorld theworld) {
        if (theworld.func_201675_m() instanceof IWP) {
            return (IWP)theworld.func_201675_m();
        }
        return null;
    }

    public static int getTier(World world, WorldMapCap.IWorldMapData data, BlockPos pos) {
        if (WorldUtils.isMapWorldClass((IWorld)world)) {
            return data.getTier(pos, (IWorld)world);
        }
        return SlashRegistry.getDimensionConfig((IWorld)world).MAP_TIER;
    }

    public static int getWorldTier(World world, BlockPos pos) {
        return SlashRegistry.getDimensionConfig((IWorld)world).MAP_TIER;
    }

    public static boolean dropsUniques(World world) {
        if (WorldUtils.isMapWorld((IWorld)world)) {
            return true;
        }
        return SlashRegistry.getDimensionConfig((IWorld)world).DROPS_UNIQUE_ITEMS;
    }
}

