/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.world_gen.processors;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.robertx22.mine_and_slash.dimensions.MapManager;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityTypeUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.RandomUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnerRandProcessor
extends StructureProcessor {
    static List<EntityType<? extends MobEntity>> possibleMobs = new ArrayList<EntityType<? extends MobEntity>>();

    public SpawnerRandProcessor() {
    }

    public SpawnerRandProcessor(Dynamic<?> dynamic) {
    }

    public static List<EntityType<? extends MobEntity>> getPossibleMobs(World world) {
        if (possibleMobs.isEmpty()) {
            SpawnerRandProcessor.setupList(world);
        }
        return possibleMobs;
    }

    static void setupList(World world) {
        if (possibleMobs.isEmpty()) {
            possibleMobs = ForgeRegistries.ENTITIES.getValues().stream().filter(x -> {
                Entity en = x.func_200721_a(world);
                return EntityTypeUtils.isMob(en) && en.func_184222_aU();
            }).map(x -> x).collect(Collectors.toList());
        }
    }

    @Nullable
    public Template.BlockInfo func_215194_a(IWorldReader iWorldReader, BlockPos blockPos, Template.BlockInfo blockInfo, Template.BlockInfo blockInfo1, PlacementSettings placementSettings) {
        try {
            Block block = blockInfo1.field_186243_b.func_177230_c();
            if (block == Blocks.field_150474_ac && RandomUtils.roll(10)) {
                if (possibleMobs.isEmpty()) {
                    World world = MapManager.getWorld(iWorldReader.func_201675_m().func_186058_p());
                    SpawnerRandProcessor.setupList(world);
                }
                EntityType<? extends MobEntity> type = RandomUtils.randomFromList(possibleMobs);
                ((CompoundNBT)blockInfo1.field_186244_c.func_74781_a("SpawnData")).func_74778_a("id", type.getRegistryName().toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return blockInfo1;
    }

    protected IStructureProcessorType func_215192_a() {
        return IStructureProcessorType.field_214924_f;
    }

    protected <T> Dynamic<T> func_215193_a(DynamicOps<T> dynamicOps) {
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of()));
    }
}

