/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.internal;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.engine.StorableEngine;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NullHelper;
import info.loenwind.autosave.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class HandleStorable<T>
implements IHandler<T> {
    @Override
    @Nullable
    public IHandler<T> getHandler(Registry registry, Type type) {
        Class<?> clazz = TypeUtil.toClass(type);
        Storable annotation = clazz.getAnnotation(Storable.class);
        return annotation != null && annotation.handler() == this.getClass() ? this : null;
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        CompoundNBT tag = new CompoundNBT();
        StorableEngine.store(registry, phase, tag, object);
        nbt.func_218657_a(name, (INBT)tag);
        return true;
    }

    @Override
    @Nullable
    public T read(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, @Nullable T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            if (object == null) {
                object = StorableEngine.instantiate(registry, type);
            }
            CompoundNBT tag = NullHelper.notnullM(nbt.func_74775_l(name), "CompoundNBT.getCompound()");
            StorableEngine.read(registry, phase, tag, object);
        }
        return object;
    }
}

