/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NonnullType;
import info.loenwind.autosave.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;

public class HandlePrimitive<T>
implements IHandler<T> {
    private final T defaultValue;
    @Nullable
    private final Class<?> primitiveClass;
    @Nonnull
    private final Class<?> boxedClass;
    @Nonnull
    private final WriterFunc<T> writer;
    @Nonnull
    private final ReaderFunc<T> reader;

    public HandlePrimitive(T defVal, Class<T> boxedClass, @Nullable Class<?> primitiveClass, WriterFunc<T> writer, ReaderFunc<T> reader) {
        this.defaultValue = defVal;
        this.primitiveClass = primitiveClass;
        this.boxedClass = boxedClass;
        this.writer = writer;
        this.reader = reader;
    }

    @Override
    @Nullable
    public IHandler<T> getHandler(Registry registry, Type type) {
        Class<?> primitive = this.primitiveClass;
        return primitive != null && TypeUtil.isAssignable(primitive, type) || TypeUtil.isAssignable(this.boxedClass, type) ? this : null;
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, T object) throws IllegalArgumentException, IllegalAccessException {
        this.writer.set(nbt, name, object);
        return true;
    }

    @Override
    @Nullable
    public T read(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, @Nullable T object) {
        return nbt.func_74764_b(name) ? this.reader.get(nbt, name) : (object != null ? object : this.defaultValue);
    }

    public static interface ReaderFunc<@NonnullType T> {
        public T get(CompoundNBT var1, String var2);
    }

    public static interface WriterFunc<@NonnullType T> {
        public void set(CompoundNBT var1, String var2, @Nullable T var3);
    }
}

