/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.java.util;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.util.HandleGenericType;
import info.loenwind.autosave.util.NBTAction;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public abstract class HandleMap<T extends Map>
extends HandleGenericType<T> {
    protected HandleMap(Class<? extends T> clazz) throws NoHandlerFoundException {
        this(clazz, Registry.GLOBAL_REGISTRY, new Type[0]);
    }

    protected HandleMap(Class<? extends T> clazz, Registry registry, Type ... types) throws NoHandlerFoundException {
        super(clazz, registry, types);
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        ListNBT tag = new ListNBT();
        for (Map.Entry e : object.entrySet()) {
            CompoundNBT etag = new CompoundNBT();
            Object key = e.getKey();
            if (key != null) {
                this.storeRecursive(0, registry, phase, etag, "key", key);
            } else {
                etag.func_74757_a("key-", true);
            }
            Object val = e.getValue();
            if (val != null) {
                this.storeRecursive(1, registry, phase, etag, "val", val);
            } else {
                etag.func_74757_a("val-", true);
            }
            tag.add((Object)etag);
        }
        nbt.func_218657_a(name, (INBT)tag);
        return true;
    }

    @Override
    @Nullable
    public T read(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, @Nullable T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        if (nbt.func_74764_b(name)) {
            if (object == null) {
                object = this.createMap();
            } else {
                object.clear();
            }
            ListNBT tag = nbt.func_150295_c(name, 10);
            for (int i = 0; i < tag.size(); ++i) {
                CompoundNBT etag = tag.func_150305_b(i);
                Object key = etag.func_74767_n("key-") ? null : this.readRecursive(0, registry, phase, etag, "key", null);
                Object val = etag.func_74767_n("val-") ? null : this.readRecursive(1, registry, phase, etag, "val", null);
                object.put(key, val);
            }
        }
        return object;
    }

    protected abstract T createMap();
}

