/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autosave.handlers.util;

import info.loenwind.autosave.Registry;
import info.loenwind.autosave.exceptions.NoHandlerFoundException;
import info.loenwind.autosave.handlers.IHandler;
import info.loenwind.autosave.util.NBTAction;
import info.loenwind.autosave.util.NonnullType;
import info.loenwind.autosave.util.TypeUtil;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;

public class DelegatingHandler<T, R>
implements IHandler<T> {
    @Nonnull
    private final Type type;
    @Nonnull
    private final IHandler<R> delegate;
    @Nonnull
    private final Function<@NonnullType T, R> storeConverter;
    @Nonnull
    private final Function<@NonnullType R, T> readConverter;

    public DelegatingHandler(Class<T> type, IHandler<R> delegate, Function<@NonnullType T, R> storeConverter, Function<@NonnullType R, T> readConverter) {
        this((Type)type, delegate, storeConverter, readConverter);
    }

    public DelegatingHandler(Type type, IHandler<R> delegate, Function<@NonnullType T, R> storeConverter, Function<@NonnullType R, T> readConverter) {
        this.type = type;
        this.delegate = delegate;
        this.storeConverter = storeConverter;
        this.readConverter = readConverter;
    }

    @Override
    public Class<?> getRootType() {
        return TypeUtil.toClass(this.type);
    }

    @Override
    public boolean store(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        R obj = this.storeConverter.apply(object);
        if (obj == null) {
            throw new IllegalArgumentException("Store converter returned null unexpectedly.");
        }
        return this.delegate.store(registry, phase, nbt, type, name, obj);
    }

    @Override
    @Nullable
    public T read(Registry registry, Set<NBTAction> phase, CompoundNBT nbt, Type type, String name, @Nullable T object) throws IllegalArgumentException, IllegalAccessException, InstantiationException, NoHandlerFoundException {
        Object intermediate = this.delegate.read(registry, phase, nbt, type, name, object == null ? null : (Object)this.storeConverter.apply(object));
        return intermediate == null ? null : (T)this.readConverter.apply(intermediate);
    }
}

