/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.dummmmmmy.DummmmmmyMod;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class Configs {
    private static final Color COLOR_GENERIC = new Color(0xFFFFFF);
    private static final Color COLOR_CRIT = new Color(0xFF0000);
    private static final Color COLOR_DRAGON = new Color(15073535);
    private static final Color COLOR_WITHER = new Color(0x666666);
    private static final Color COLOR_EXPLOSION = new Color(16759593);
    private static final Color COLOR_IND_MAGIC = new Color(8670439);
    private static final Color COLOR_MAGIC = new Color(3387903);
    private static final Color COLOR_TRIDENT = new Color(65437);
    private static final Color COLOR_FIRE = new Color(0xFF7700);
    private static final Color COLOR_LIGHTNING = new Color(0xFFF200);
    private static final Color COLOR_CACTUS = new Color(296192);
    private static final Color COLOR_TRUE = new Color(9502776);
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec.DoubleValue ANIMATION_INTENSITY;
    public static ForgeConfigSpec.BooleanValue SHOW_HEARTHS;
    public static ForgeConfigSpec.BooleanValue DYNAMIC_DPS;
    public static ForgeConfigSpec.ConfigValue<SkinType> SKIN;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_GENERIC;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_CRIT;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_DRAGON;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_WITHER;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_EXPLOSION;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_IND_MAGIC;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_TRIDENT;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_MAGIC;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_FIRE;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_LIGHTNING;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_CACTUS;
    public static ForgeConfigSpec.ConfigValue<String> DAMAGE_TRUE;
    public static ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec.BooleanValue DAMAGE_EQUIPMENT;
    public static ForgeConfigSpec.IntValue RADIUS;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> WHITELIST;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> BLACKLIST;

    public static void reloadConfigsEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getSpec() == CLIENT_CONFIG) {
            cached.refresh();
        } else if (event.getConfig().getSpec() == SERVER_CONFIG) {
            cachedServer.refresh();
        }
    }

    private static String col2String(Color color) {
        return Integer.toHexString(color.getRGB()).substring(2);
    }

    private static int parseHex(String s) {
        int hex = 0xFFFFFF;
        try {
            hex = Integer.parseInt(s.replace("0x", ""), 16);
        }
        catch (Exception e) {
            DummmmmmyMod.LOGGER.warn("failed to parse damage source color from config");
        }
        return hex;
    }

    private static boolean isValidHex(Object s) {
        try {
            Integer.parseInt(((String)s).replace("0x", ""), 16);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("lots of cosmetic stuff in here").push("visuals");
        ANIMATION_INTENSITY = builder.comment("How much the dummy swings in degrees with respect to the damage dealt. default=0.75").defineInRange("animationIntensity", 0.75, 0.0, 2.0);
        SHOW_HEARTHS = builder.comment("Show hearths instead of damage dealt? (1 hearth = two damage)").define("showHearths", false);
        DYNAMIC_DPS = builder.comment("Does dps message update dynamically or will it only appear after each parse? ").define("dynamicDPS", true);
        SKIN = builder.comment("Skin used by the dummy").define("texture", (Object)SkinType.DEFAULT);
        builder.push("damage_number_colors").comment("hex color for various damage sources");
        DAMAGE_GENERIC = builder.define("genetic", (Object)Configs.col2String(COLOR_GENERIC), Configs::isValidHex);
        DAMAGE_CRIT = builder.define("crit", (Object)Configs.col2String(COLOR_CRIT), Configs::isValidHex);
        DAMAGE_DRAGON = builder.define("dragon_breath", (Object)Configs.col2String(COLOR_DRAGON), Configs::isValidHex);
        DAMAGE_WITHER = builder.define("wither", (Object)Configs.col2String(COLOR_WITHER), Configs::isValidHex);
        DAMAGE_EXPLOSION = builder.define("explosion", (Object)Configs.col2String(COLOR_EXPLOSION), Configs::isValidHex);
        DAMAGE_IND_MAGIC = builder.define("magic_indirect", (Object)Configs.col2String(COLOR_IND_MAGIC), Configs::isValidHex);
        DAMAGE_MAGIC = builder.define("magic", (Object)Configs.col2String(COLOR_MAGIC), Configs::isValidHex);
        DAMAGE_TRIDENT = builder.define("trident", (Object)Configs.col2String(COLOR_TRIDENT), Configs::isValidHex);
        DAMAGE_FIRE = builder.define("fire", (Object)Configs.col2String(COLOR_FIRE), Configs::isValidHex);
        DAMAGE_LIGHTNING = builder.define("lightning", (Object)Configs.col2String(COLOR_LIGHTNING), Configs::isValidHex);
        DAMAGE_CACTUS = builder.define("cactus", (Object)Configs.col2String(COLOR_CACTUS), Configs::isValidHex);
        DAMAGE_TRUE = builder.define("true", (Object)Configs.col2String(COLOR_TRUE), Configs::isValidHex);
        builder.pop();
        builder.pop();
        CLIENT_CONFIG = builder.build();
        ForgeConfigSpec.Builder serverBuilder = new ForgeConfigSpec.Builder();
        serverBuilder.push("scarecrow").comment("Equip a dummy with a pumpkin to make hit act as a scarecrow");
        WHITELIST = serverBuilder.comment("All animal entities will be scared. add here additional ones that are not included").defineList("mobs_whitelist", Collections.singletonList(""), s -> true);
        BLACKLIST = serverBuilder.comment("Animal entities that will not be scared").defineList("mobs_blacklist", Collections.singletonList(""), s -> true);
        RADIUS = serverBuilder.comment("Scaring radius").defineInRange("scare_radius", 12, 0, 100);
        serverBuilder.pop();
        DAMAGE_EQUIPMENT = serverBuilder.comment("Enable this to prevent your equipment from getting damaged when attacking the dummy").define("disable_equipment_damage", true);
        SERVER_CONFIG = serverBuilder.build();
    }

    public static enum SkinType {
        DEFAULT("dummy", "dummy_h"),
        ORIGINAL("dummy_1", "dummy_1"),
        DUNGEONS("dummy_3", "dummy_3_h"),
        ALTERNATIVE("dummy_2", "dummy_2_h");

        private final ResourceLocation texture;
        private final ResourceLocation shearedTexture;

        private SkinType(String name, String shearedName) {
            this.texture = new ResourceLocation("dummmmmmy:textures/" + name + ".png");
            this.shearedTexture = new ResourceLocation("dummmmmmy:textures/" + shearedName + ".png");
        }

        public ResourceLocation getSkin(Boolean sheared) {
            return sheared != false ? this.shearedTexture : this.texture;
        }
    }

    public static class cached {
        public static double ANIMATION_INTENSITY;
        public static boolean SHOW_HEARTHS;
        public static boolean DYNAMIC_DPS;
        public static SkinType SKIN;
        public static int DAMAGE_GENERIC;
        public static int DAMAGE_CRIT;
        public static int DAMAGE_DRAGON;
        public static int DAMAGE_WITHER;
        public static int DAMAGE_EXPLOSION;
        public static int DAMAGE_IND_MAGIC;
        public static int DAMAGE_TRIDENT;
        public static int DAMAGE_MAGIC;
        public static int DAMAGE_FIRE;
        public static int DAMAGE_LIGHTNING;
        public static int DAMAGE_CACTUS;
        public static int DAMAGE_TRUE;

        public static void refresh() {
            ANIMATION_INTENSITY = (Double)ANIMATION_INTENSITY.get();
            SHOW_HEARTHS = (Boolean)SHOW_HEARTHS.get();
            DYNAMIC_DPS = (Boolean)DYNAMIC_DPS.get();
            SKIN = (SkinType)((Object)SKIN.get());
            DAMAGE_GENERIC = Configs.parseHex((String)DAMAGE_GENERIC.get());
            DAMAGE_CRIT = Configs.parseHex((String)DAMAGE_CRIT.get());
            DAMAGE_DRAGON = Configs.parseHex((String)DAMAGE_DRAGON.get());
            DAMAGE_WITHER = Configs.parseHex((String)DAMAGE_WITHER.get());
            DAMAGE_EXPLOSION = Configs.parseHex((String)DAMAGE_EXPLOSION.get());
            DAMAGE_IND_MAGIC = Configs.parseHex((String)DAMAGE_IND_MAGIC.get());
            DAMAGE_TRIDENT = Configs.parseHex((String)DAMAGE_TRIDENT.get());
            DAMAGE_MAGIC = Configs.parseHex((String)DAMAGE_MAGIC.get());
            DAMAGE_FIRE = Configs.parseHex((String)DAMAGE_FIRE.get());
            DAMAGE_LIGHTNING = Configs.parseHex((String)DAMAGE_LIGHTNING.get());
            DAMAGE_CACTUS = Configs.parseHex((String)DAMAGE_CACTUS.get());
            DAMAGE_TRUE = Configs.parseHex((String)DAMAGE_TRUE.get());
        }
    }

    public static class cachedServer {
        public static List<? extends String> WHITELIST;
        public static List<? extends String> BLACKLIST;
        public static int RADIUS;
        public static boolean DAMAGE_EQUIPMENT;

        public static void refresh() {
            RADIUS = (Integer)RADIUS.get();
            WHITELIST = (List)WHITELIST.get();
            BLACKLIST = (List)BLACKLIST.get();
            DAMAGE_EQUIPMENT = (Boolean)DAMAGE_EQUIPMENT.get();
        }
    }
}

