/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import net.mehvahdjukaar.dummmmmmy.common.Configs;
import net.mehvahdjukaar.dummmmmmy.entity.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.setup.Registry;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Events {
    @SubscribeEvent
    public static void onEntityCriticalHit(CriticalHitEvent event) {
        if (event != null && event.getEntity() != null) {
            Entity target = event.getTarget();
            if ((double)event.getDamageModifier() == 1.5 && target instanceof TargetDummyEntity) {
                TargetDummyEntity dummy = (TargetDummyEntity)target;
                dummy.critical = true;
            }
        }
    }

    public static boolean isScared(Entity entity) {
        String name = entity.func_200600_R().getRegistryName().toString();
        return (entity instanceof AnimalEntity || Configs.cachedServer.WHITELIST.contains(name)) && !Configs.cachedServer.BLACKLIST.contains(name);
    }

    public static boolean isScarecrowInRange(Entity entity, World world) {
        return !world.func_217394_a((EntityType)Registry.TARGET_DUMMY.get(), entity.func_174813_aQ().func_186662_g(10.0), TargetDummyEntity::isScarecrow).isEmpty();
    }

    @SubscribeEvent
    public static void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        World world = event.getEntity().field_70170_p;
        Entity entity = event.getEntity();
        if (Events.isScared(entity) && Events.isScarecrowInRange(entity, world)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld() == null) {
            return;
        }
        Entity e = event.getEntity();
        if (e instanceof CreatureEntity && Events.isScared(e)) {
            CreatureEntity mob = (CreatureEntity)e;
            mob.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal(mob, TargetDummyEntity.class, (float)Configs.cachedServer.RADIUS, 1.0, 1.3, d -> ((TargetDummyEntity)((Object)d)).isScarecrow()));
        }
    }
}

