/*
 * Decompiled with CFR 0.152.
 */
package com.nuparu.nightterror;

import com.nuparu.nightterror.config.Config;
import com.nuparu.nightterror.config.ConfigHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="nightterror")
public class NightTerror {
    private static final Logger LOGGER = LogManager.getLogger();
    public static Method m_isDirectPathBetweenPoints;

    public NightTerror() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, ConfigHelper.config);
        ConfigHelper.loadConfig(ConfigHelper.config, FMLPaths.CONFIGDIR.get().resolve("nightterror-common.toml").toString());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        m_isDirectPathBetweenPoints = ObfuscationReflectionHelper.findMethod(PathNavigator.class, (String)"func_75493_a", (Class[])new Class[]{Vector3d.class, Vector3d.class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        if (event.getResultStatus() != PlayerEntity.SleepResult.NOT_SAFE && event.getResultStatus() != null) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (ForgeEventFactory.fireSleepingTimeCheck((PlayerEntity)player, (Optional)event.getOptionalPos())) {
            event.setResult((PlayerEntity.SleepResult)null);
            player.func_213342_e((BlockPos)event.getOptionalPos().get());
            ObfuscationReflectionHelper.setPrivateValue(PlayerEntity.class, (Object)player, (Object)0, (String)"field_71076_b");
            if (player.field_70170_p instanceof ServerWorld) {
                ((ServerWorld)player.field_70170_p).func_72854_c();
            }
        }
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent event) {
        IWorld iw = event.getWorld();
        if (iw instanceof IServerWorld) {
            IServerWorld world = (IServerWorld)event.getWorld();
            MinecraftServer server = world.func_201672_e().func_73046_m();
            if (server == null) {
                return;
            }
            List players = server.func_184103_al().func_181057_v();
            boolean finished = true;
            block2: for (ServerPlayerEntity player : players) {
                if (player.func_184812_l_() || player.func_175149_v()) continue;
                BlockPos bed = (BlockPos)player.func_213374_dv().get();
                BlockState state = world.func_180495_p(bed);
                boolean woke = false;
                if (world.func_201674_k().nextDouble() > (Double)Config.terrorChance.get() * NightTerror.getModifier(world)) continue;
                for (int x = -((Integer)Config.checkRange.get()).intValue(); x < (Integer)Config.checkRange.get(); ++x) {
                    for (int y = -((Integer)Config.checkRange.get()).intValue() / 2; y < (Integer)Config.checkRange.get() / 2; ++y) {
                        for (int z = -((Integer)Config.checkRange.get()).intValue(); z < (Integer)Config.checkRange.get(); ++z) {
                            MobEntity mob;
                            block14: {
                                ArrayList list = new ArrayList();
                                list.addAll((Collection)Config.wakingEntites.get());
                                if (list.size() < 1) {
                                    return;
                                }
                                BlockPos pos = bed.func_177982_a(x, y, z);
                                mob = null;
                                while (mob == null && list.size() > 0) {
                                    int index = world.func_201674_k().nextInt(list.size());
                                    Optional o = EntityType.func_220327_a((String)((String)list.get(index)));
                                    list.remove(index);
                                    if (!o.isPresent()) continue;
                                    EntityType type = (EntityType)o.get();
                                    Entity entity = type.func_200721_a((World)world.func_201672_e());
                                    if (!(entity instanceof MobEntity)) {
                                        LOGGER.warn(type.func_212546_e() + " is not an instance of MobEntity! Skipping.");
                                        continue;
                                    }
                                    mob = (MobEntity)entity;
                                }
                                if (mob == null) {
                                    return;
                                }
                                if (!ZombieEntity.func_223323_a((IServerWorld)world, (BlockPos)pos, (Random)world.func_201674_k())) continue;
                                try {
                                    boolean path = (Boolean)m_isDirectPathBetweenPoints.invoke((Object)mob.func_70661_as(), new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), new Vector3d((double)bed.func_177958_n(), (double)bed.func_177956_o(), (double)bed.func_177952_p()), 1, 1, 1);
                                    if (!path) {
                                    }
                                    break block14;
                                }
                                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                                    e.printStackTrace();
                                }
                                continue;
                            }
                            world.func_217376_c((Entity)mob);
                            Optional vec = state.getBedSpawnPosition(EntityType.field_200729_aH, (IWorldReader)world.func_201672_e(), bed, player.func_242109_L(), null);
                            mob.func_70107_b(((Vector3d)vec.get()).field_72450_a, ((Vector3d)vec.get()).field_72448_b, ((Vector3d)vec.get()).field_72449_c);
                            mob.func_70671_ap().func_75650_a(player.func_226277_ct_(), player.func_226278_cu_() + (double)player.func_70047_e(), player.func_226281_cx_(), (float)mob.func_184649_cE(), (float)mob.func_70646_bf());
                            player.func_70652_k((Entity)mob);
                            player.func_70097_a(DamageSource.func_76358_a((LivingEntity)mob), (float)((Integer)Config.wakeDamage.get()).intValue());
                            woke = true;
                            finished = false;
                            break;
                        }
                        if (woke) break;
                    }
                    if (woke) continue block2;
                }
            }
            if (!finished && ((Boolean)Config.interruptSleep.get()).booleanValue()) {
                event.setTimeAddition(world.func_201672_e().func_72820_D());
            }
        }
    }

    public static double getModifier(IServerWorld world) {
        switch (world.func_175659_aa()) {
            default: {
                return 0.5;
            }
            case EASY: {
                return 0.75;
            }
            case NORMAL: {
                return 1.0;
            }
            case HARD: 
        }
        return 1.5;
    }
}

