/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.blocks;

import com.fizzware.dramaticdoors.blocks.TallDoorBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.commons.lang3.NotImplementedException;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
@ObjectHolder(value="dramaticdoors")
public class DramaticDoorsBlocks {
    @ObjectHolder(value="tall_oak_door")
    public static final Block TALL_OAK_DOOR = null;
    @ObjectHolder(value="tall_spruce_door")
    public static final Block TALL_SPRUCE_DOOR = null;
    @ObjectHolder(value="tall_birch_door")
    public static final Block TALL_BIRCH_DOOR = null;
    @ObjectHolder(value="tall_jungle_door")
    public static final Block TALL_JUNGLE_DOOR = null;
    @ObjectHolder(value="tall_acacia_door")
    public static final Block TALL_ACACIA_DOOR = null;
    @ObjectHolder(value="tall_dark_oak_door")
    public static final Block TALL_DARK_OAK_DOOR = null;
    @ObjectHolder(value="tall_iron_door")
    public static final Block TALL_IRON_DOOR = null;
    @ObjectHolder(value="tall_crimson_door")
    public static final Block TALL_CRIMSON_DOOR = null;
    @ObjectHolder(value="tall_warped_door")
    public static final Block TALL_WARPED_DOOR = null;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> blockRegistry) {
        Block[] vanillaDoors = DramaticDoorsBlocks.getBlockList(DoorSeries.VANILLA);
        String[] tallDoorNames = TallDoorBlock.getNames();
        IForgeRegistry registry = blockRegistry.getRegistry();
        for (int i = 0; i < vanillaDoors.length; ++i) {
            registry.register(new TallDoorBlock(vanillaDoors[i]).setRegistryName(new ResourceLocation("dramaticdoors", tallDoorNames[i])));
        }
    }

    public static Block[] getBlockList(DoorSeries series) {
        switch (series) {
            case VANILLA: {
                return new Block[]{Blocks.field_180413_ao, Blocks.field_180414_ap, Blocks.field_180412_aq, Blocks.field_180411_ar, Blocks.field_180410_as, Blocks.field_180409_at, Blocks.field_150454_av, Blocks.field_235360_mS_, Blocks.field_235361_mT_};
            }
            case VANILLA_TALL: {
                return new Block[]{TALL_OAK_DOOR, TALL_SPRUCE_DOOR, TALL_BIRCH_DOOR, TALL_JUNGLE_DOOR, TALL_ACACIA_DOOR, TALL_DARK_OAK_DOOR, TALL_IRON_DOOR, TALL_CRIMSON_DOOR, TALL_WARPED_DOOR};
            }
            case BOP: {
                throw new NotImplementedException("Biomes O' Plenty not yet supported.");
            }
            case BOP_TALL: {
                throw new NotImplementedException("Biomes O' Plenty not yet supported.");
            }
            case UPGRADE_AQUATIC: {
                throw new NotImplementedException("Upgrade Aquatic not yet supported.");
            }
            case UPGRADE_AQUATIC_TALL: {
                throw new NotImplementedException("Upgrade Aquatic not yet supported.");
            }
        }
        return new Block[0];
    }

    public static enum DoorSeries {
        VANILLA,
        VANILLA_TALL,
        BOP,
        BOP_TALL,
        UPGRADE_AQUATIC,
        UPGRADE_AQUATIC_TALL;

    }
}

