/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayDeque;
import java.util.Deque;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;

public enum PlayerRenderHandler {
    INSTANCE;

    public static boolean Disabled;
    private LoadingCache<Object, Deque<Runnable>> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Object, Deque<Runnable>>(){

        public Deque<Runnable> load(Object key) throws Exception {
            return new ArrayDeque<Runnable>();
        }
    });

    private void handleLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        Disabled = false;
    }

    private void handlePostRenderPlayer_Low(RenderPlayerEvent.Post event) {
        this.restoreItems((Deque)this.cache.getUnchecked((Object)event.getPlayer()));
    }

    private void handlePreRenderPlayer_High(RenderPlayerEvent.Pre event) {
        PlayerEntity player = event.getPlayer();
        Deque queue = (Deque)this.cache.getUnchecked((Object)player);
        this.restoreItems(queue);
        NonNullList armor = player.field_71071_by.field_70460_b;
        int i = 0;
        while (i < armor.size()) {
            int slot = i++;
            ItemStack stack = (ItemStack)armor.get(slot);
            queue.add(() -> {
                ItemStack cfr_ignored_0 = (ItemStack)armor.set(slot, (Object)stack);
            });
        }
        if (Disabled) {
            return;
        }
        InventoryCosArmor invCosArmor = ModObjects.invMan.getCosArmorInventoryClient(player.func_110124_au());
        for (int i2 = 0; i2 < armor.size(); ++i2) {
            if (invCosArmor.isSkinArmor(i2)) {
                armor.set(i2, (Object)ItemStack.field_190927_a);
                continue;
            }
            ItemStack stack = invCosArmor.func_70301_a(i2);
            if (stack.func_190926_b()) continue;
            armor.set(i2, (Object)stack);
        }
    }

    private void handlePreRenderPlayer_LowestCanceled(RenderPlayerEvent.Pre event) {
        if (!event.isCanceled()) {
            return;
        }
        this.restoreItems((Deque)this.cache.getUnchecked((Object)event.getPlayer()));
    }

    public void registerEvents() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, this::handlePostRenderPlayer_Low);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, this::handlePreRenderPlayer_High);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, true, this::handlePreRenderPlayer_LowestCanceled);
        MinecraftForge.EVENT_BUS.addListener(this::handleLoggedOut);
    }

    private void restoreItems(Deque<Runnable> queue) {
        Runnable runnable;
        while ((runnable = queue.poll()) != null) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                ModObjects.logger.error("Failed in restoring client player items", e);
            }
        }
    }

    static {
        Disabled = false;
    }
}

