/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.init;

import com.mrcrayfish.goblintraders.entity.GoblinTraderEntity;
import com.mrcrayfish.goblintraders.entity.VeinGoblinTraderEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="goblintraders", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    private static final List<EntityType<?>> ENTITY_TYPES = new ArrayList();
    public static final EntityType<GoblinTraderEntity> GOBLIN_TRADER = ModEntities.build(new ResourceLocation("goblintraders", "goblin_trader"), GoblinTraderEntity::new, 0.5f, 1.0f);
    public static final EntityType<VeinGoblinTraderEntity> VEIN_GOBLIN_TRADER = ModEntities.build(new ResourceLocation("goblintraders", "vein_goblin_trader"), VeinGoblinTraderEntity::new, 0.5f, 1.0f);

    private static <T extends Entity> EntityType<T> build(ResourceLocation id, Function<World, T> function, float width, float height) {
        EntityType type = EntityType.Builder.func_220322_a((entityType, world) -> (Entity)function.apply(world), (EntityClassification)EntityClassification.CREATURE).func_220321_a(width, height).setCustomClientFactory((spawnEntity, world) -> (Entity)function.apply((World)world)).func_206830_a(id.toString());
        type.setRegistryName(id);
        ENTITY_TYPES.add(type);
        return type;
    }

    @SubscribeEvent
    public static void registerTypes(RegistryEvent.Register<EntityType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        ENTITY_TYPES.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    public static void registerEntityTypeAttributes() {
        GlobalEntityTypeAttributes.put(GOBLIN_TRADER, (AttributeModifierMap)GoblinTraderEntity.prepareAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(VEIN_GOBLIN_TRADER, (AttributeModifierMap)VeinGoblinTraderEntity.prepareAttributes().func_233813_a_());
    }
}

