/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.world.spawner;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.world.spawner.GoblinData;
import com.mrcrayfish.goblintraders.world.spawner.GoblinTraderData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppedEvent;

@Mod.EventBusSubscriber(modid="goblintraders")
public class GoblinTraderSpawner {
    private final Random random = new Random();
    private final ServerWorld world;
    private final GoblinData data;
    private int delayBeforeSpawnLogic;
    private int traderSpawnDelay;
    private int traderSpawnChance;
    private EntityType<? extends AbstractGoblinEntity> entityType;
    private int minLevel;
    private int maxLevel;
    private static List<GoblinTraderSpawner> spawners = new ArrayList<GoblinTraderSpawner>();

    public GoblinTraderSpawner(ServerWorld world, GoblinData data, EntityType<? extends AbstractGoblinEntity> entityType, int minLevel, int maxLevel) {
        this.world = world;
        this.data = data;
        this.delayBeforeSpawnLogic = 600;
        this.traderSpawnDelay = data.getGoblinTraderSpawnDelay();
        this.traderSpawnChance = data.getGoblinTraderSpawnChance();
        this.entityType = entityType;
        this.minLevel = Math.min(minLevel, maxLevel);
        this.maxLevel = Math.max(minLevel, maxLevel);
        if (this.traderSpawnDelay == 0 && this.traderSpawnChance == 0) {
            this.traderSpawnDelay = 24000;
            this.traderSpawnChance = 25;
            data.setGoblinTraderSpawnDelay(this.traderSpawnDelay);
            data.setGoblinTraderSpawnChance(this.traderSpawnChance);
        }
    }

    private void tick() {
        if (this.world.func_82736_K().func_223586_b(GameRules.field_230128_E_) && --this.delayBeforeSpawnLogic <= 0) {
            this.delayBeforeSpawnLogic = 1200;
            this.traderSpawnDelay -= 1200;
            this.data.setGoblinTraderSpawnDelay(this.traderSpawnDelay);
            if (this.traderSpawnDelay <= 0) {
                this.traderSpawnDelay = 24000;
                if (this.world.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
                    int i = this.traderSpawnChance;
                    this.traderSpawnChance = MathHelper.func_76125_a((int)(this.traderSpawnChance + 25), (int)25, (int)75);
                    this.data.setGoblinTraderSpawnChance(this.traderSpawnChance);
                    if (this.random.nextInt(100) <= i && this.spawnTrader()) {
                        this.traderSpawnChance = 25;
                    }
                }
            }
        }
    }

    private boolean spawnTrader() {
        ArrayList players = new ArrayList(this.world.func_217369_A());
        if (players.isEmpty()) {
            return false;
        }
        PlayerEntity randomPlayer = (PlayerEntity)players.get(this.world.field_73012_v.nextInt(players.size()));
        if (randomPlayer == null) {
            return true;
        }
        if (this.random.nextInt(5) != 0) {
            return false;
        }
        BlockPos blockpos = randomPlayer.func_233580_cy_();
        BlockPos safestPos = this.getSafePositionAroundPlayer(randomPlayer.field_70170_p, blockpos, 10);
        if (safestPos != null && this.isEmptyCollision(randomPlayer.field_70170_p, safestPos)) {
            if (safestPos.func_177956_o() < this.minLevel || safestPos.func_177956_o() >= this.maxLevel) {
                return false;
            }
            AbstractGoblinEntity goblin = (AbstractGoblinEntity)this.entityType.func_220342_a((ServerWorld)randomPlayer.field_70170_p, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, safestPos, SpawnReason.EVENT, false, false);
            if (goblin != null) {
                this.data.setGoblinTraderId(goblin.func_110124_au());
                goblin.setDespawnDelay(24000);
                goblin.func_213390_a(safestPos, 16);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private BlockPos getSafePositionAroundPlayer(World world, BlockPos pos, int range) {
        if (range == 0) {
            return null;
        }
        BlockPos safestPos = null;
        for (int attempts = 0; attempts < 50; ++attempts) {
            int posZ;
            int posY;
            int posX = pos.func_177958_n() + this.random.nextInt(range * 2) - range;
            BlockPos testPos = this.findGround(world, new BlockPos(posX, posY = pos.func_177956_o() + this.random.nextInt(range) - range / 2, posZ = pos.func_177952_p() + this.random.nextInt(range * 2) - range), range);
            if (testPos == null || !WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)world, (BlockPos)testPos, ModEntities.GOBLIN_TRADER)) continue;
            safestPos = testPos;
            break;
        }
        return safestPos != null ? safestPos : this.getSafePositionAroundPlayer(world, pos, range / 2);
    }

    @Nullable
    private BlockPos findGround(World world, BlockPos pos, int maxDistance) {
        System.out.println(world.func_180495_p(pos).func_177230_c().getRegistryName());
        if (world.func_175623_d(pos)) {
            BlockPos downPos = pos;
            while (World.func_175701_a((BlockPos)downPos.func_177977_b()) && world.func_175623_d(downPos.func_177977_b()) && downPos.func_177977_b().func_218141_a((Vector3i)pos, (double)maxDistance)) {
                downPos = downPos.func_177977_b();
            }
            if (!world.func_175623_d(downPos.func_177977_b())) {
                return downPos;
            }
        } else {
            BlockPos upPos = pos;
            while (World.func_175701_a((BlockPos)upPos.func_177984_a()) && !world.func_175623_d(upPos.func_177984_a()) && upPos.func_177984_a().func_218141_a((Vector3i)pos, (double)maxDistance)) {
                upPos = upPos.func_177984_a();
            }
            if (!world.func_175623_d(upPos.func_177977_b())) {
                return upPos;
            }
        }
        return null;
    }

    private boolean isEmptyCollision(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b();
    }

    @SubscribeEvent
    public static void onServerStart(FMLServerStartedEvent event) {
        MinecraftServer server = event.getServer();
        GoblinTraderData traderData = GoblinTraderData.get(server);
        spawners.add(new GoblinTraderSpawner(server.func_71218_a(World.field_234918_g_), traderData.getGoblinData("GoblinTrader"), ModEntities.GOBLIN_TRADER, 0, 64));
        spawners.add(new GoblinTraderSpawner(server.func_71218_a(World.field_234919_h_), traderData.getGoblinData("VeinGoblinTrader"), ModEntities.VEIN_GOBLIN_TRADER, 0, 128));
    }

    @SubscribeEvent
    public static void onServerStart(FMLServerStoppedEvent event) {
        spawners.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        if (!event.world.func_234923_W_().equals(World.field_234918_g_)) {
            return;
        }
        spawners.forEach(GoblinTraderSpawner::tick);
    }
}

