/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.GBForgetools;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import de.guntram.mcmod.GBForgetools.ConfigChangedEvent;
import de.guntram.mcmod.GBForgetools.Configuration;
import de.guntram.mcmod.GBForgetools.ModConfigurationHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GuiModOptions
extends Screen {
    private final Screen parent;
    private final String modName;
    private final ModConfigurationHandler handler;
    private final List<String> options;
    private final Logger LOGGER;
    private String screenTitle;
    private static final int LINEHEIGHT = 25;
    private static final int BUTTONHEIGHT = 20;
    private boolean mouseReleased = false;
    private static final IFormattableTextComponent trueText = new TranslationTextComponent("de.guntram.mcmod.fabrictools.true").func_240699_a_(TextFormatting.GREEN);
    private static final IFormattableTextComponent falseText = new TranslationTextComponent("de.guntram.mcmod.fabrictools.false").func_240699_a_(TextFormatting.RED);

    public GuiModOptions(Screen parent, String modName, ModConfigurationHandler confHandler) {
        super((ITextComponent)new StringTextComponent(modName));
        this.parent = parent;
        this.modName = modName;
        this.handler = confHandler;
        this.screenTitle = modName + " Configuration";
        this.options = this.handler.getConfig().getKeys();
        this.LOGGER = LogManager.getLogger();
    }

    protected void func_231160_c_() {
        this.func_230480_a_(new Widget(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 27, 200, 20, (ITextComponent)new TranslationTextComponent("gui.done")){

            public void func_230982_a_(double x, double y) {
                for (Widget button : GuiModOptions.this.field_230710_m_) {
                    if (!(button instanceof TextFieldWidget) || !button.func_230999_j_()) continue;
                    button.func_231049_c__(false);
                }
                GuiModOptions.this.handler.onConfigChanged(new ConfigChangedEvent.OnConfigChangedEvent(GuiModOptions.this.modName));
                GuiModOptions.this.field_230706_i_.func_147108_a(GuiModOptions.this.parent);
            }
        });
        int y = 25;
        for (final String text : this.options) {
            Widget element;
            y += 25;
            Object value = this.handler.getConfig().getValue(text);
            if (value == null) {
                LogManager.getLogger().warn("value null, adding nothing");
                continue;
            }
            if (this.handler.getConfig().isSelectList(text)) {
                final String[] options = this.handler.getConfig().getListOptions(text);
                element = this.func_230480_a_(new Widget(this.field_230708_k_ / 2 + 10, y, 200, 20, (ITextComponent)new TranslationTextComponent(options[(Integer)value])){

                    public void func_230982_a_(double x, double y) {
                        int cur = (Integer)GuiModOptions.this.handler.getConfig().getValue(text);
                        if (++cur == options.length) {
                            cur = 0;
                        }
                        GuiModOptions.this.handler.getConfig().setValue(text, cur);
                        GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, text, cur));
                        this.func_231049_c__(true);
                    }

                    public void func_230995_c_(boolean b) {
                        int cur = (Integer)GuiModOptions.this.handler.getConfig().getValue(text);
                        this.func_238482_a_((ITextComponent)new TranslationTextComponent(options[cur]));
                        super.func_230995_c_(b);
                    }
                });
            } else if (value instanceof Boolean) {
                element = this.func_230480_a_(new Widget(this.field_230708_k_ / 2 + 10, y, 200, 20, (ITextComponent)((Boolean)value == true ? trueText : falseText)){

                    public void func_230982_a_(double x, double y) {
                        if (((Boolean)GuiModOptions.this.handler.getConfig().getValue(text)).booleanValue()) {
                            GuiModOptions.this.handler.getConfig().setValue(text, false);
                            GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, text, false));
                        } else {
                            GuiModOptions.this.handler.getConfig().setValue(text, true);
                            GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, text, true));
                        }
                        this.func_231049_c__(true);
                    }

                    public void func_230995_c_(boolean b) {
                        this.func_238482_a_((ITextComponent)((Boolean)GuiModOptions.this.handler.getConfig().getValue(text) == true ? trueText : falseText));
                        super.func_230995_c_(b);
                    }
                });
            } else if (value instanceof String) {
                element = this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 + 10, y, 200, 20, (ITextComponent)new StringTextComponent((String)value)){

                    public void func_230995_c_(boolean b) {
                        if (b) {
                            GuiModOptions.this.LOGGER.info("value to textfield");
                            this.func_146180_a((String)GuiModOptions.this.handler.getConfig().getValue(text));
                        } else {
                            GuiModOptions.this.LOGGER.info("textfield to value");
                            GuiModOptions.this.handler.getConfig().setValue(text, this.func_146179_b());
                        }
                        super.func_230995_c_(b);
                    }

                    public boolean func_231042_a_(char chr, int keyCode) {
                        boolean result = super.func_231042_a_(chr, keyCode);
                        GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, text, this.func_146179_b()));
                        return result;
                    }

                    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
                        boolean result = super.func_231046_a_(keyCode, scanCode, modifiers);
                        GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, text, this.func_146179_b()));
                        return result;
                    }
                });
                element.func_231049_c__(false);
            } else if (value instanceof Integer || value instanceof Float || value instanceof Double) {
                element = this.func_230480_a_(new GuiSlider(this.field_230708_k_ / 2 + 10, y, this.handler.getConfig(), text));
            } else {
                LogManager.getLogger().warn(this.modName + " has option " + text + " with data type " + value.getClass().getName());
                continue;
            }
            this.func_230480_a_(new Widget(this.field_230708_k_ / 2 + 220, y, 20, 20, (ITextComponent)new StringTextComponent("")){

                public void func_230982_a_(double x, double y) {
                    GuiModOptions.this.handler.getConfig().setValue(text, GuiModOptions.this.handler.getConfig().getDefault(text));
                    GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, text, GuiModOptions.this.handler.getConfig().getDefault(text)));
                    element.func_231049_c__(false);
                }
            });
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        GuiModOptions.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)this.screenTitle, (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        int y = 50;
        for (String text : this.options) {
            this.field_230712_o_.func_238422_b_(stack, new TranslationTextComponent(text).func_241878_f(), (float)(this.field_230708_k_ / 2 - 155), (float)(y + 2), 0xFFFFFF);
            y += 25;
        }
        y = 50;
        for (String text : this.options) {
            if (mouseX > this.field_230708_k_ / 2 - 155 && mouseX < this.field_230708_k_ / 2 && mouseY > y && mouseY < y + 20) {
                TranslationTextComponent tooltip = new TranslationTextComponent(this.handler.getConfig().getTooltip(text));
                if (this.field_230712_o_.func_238414_a_((ITextProperties)tooltip) <= 250) {
                    this.func_238652_a_(stack, (ITextComponent)tooltip, mouseX, mouseY);
                } else {
                    List lines = this.field_230712_o_.func_238425_b_((ITextProperties)tooltip, 250);
                    this.func_238654_b_(stack, lines, mouseX, mouseY);
                }
            }
            y += 25;
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.mouseReleased = true;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    private class GuiSlider
    extends Widget {
        Type type;
        boolean dragging;
        double sliderValue;
        double min;
        double max;
        Configuration config;
        String configOption;

        GuiSlider(int x, int y, Configuration config, String option) {
            super(x, y, 200, 20, (ITextComponent)new StringTextComponent("?"));
            Object value = config.getValue(option);
            if (value instanceof Double) {
                this.func_238482_a_((ITextComponent)new StringTextComponent(Double.toString((Double)value)));
                this.min = (Double)config.getMin(option);
                this.max = (Double)config.getMax(option);
                this.sliderValue = ((Double)value - this.min) / (this.max - this.min);
                this.type = Type.DOUBLE;
            } else if (value instanceof Float) {
                this.func_238482_a_((ITextComponent)new StringTextComponent(Float.toString(((Float)value).floatValue())));
                this.min = ((Float)config.getMin(option)).floatValue();
                this.max = ((Float)config.getMax(option)).floatValue();
                this.sliderValue = ((double)((Float)value).floatValue() - this.min) / (this.max - this.min);
                this.type = Type.FLOAT;
            } else {
                this.func_238482_a_((ITextComponent)new StringTextComponent(Integer.toString((Integer)value)));
                this.min = ((Integer)config.getMin(option)).intValue();
                this.max = ((Integer)config.getMax(option)).intValue();
                this.sliderValue = ((double)((Integer)value).intValue() - this.min) / (this.max - this.min);
                this.type = Type.INT;
            }
            this.config = config;
            this.configOption = option;
        }

        private void updateValue(double value) {
            switch (this.type) {
                case DOUBLE: {
                    double doubleVal = value * (this.max - this.min) + this.min;
                    this.func_238482_a_((ITextComponent)new StringTextComponent(Double.toString(doubleVal)));
                    this.config.setValue(this.configOption, doubleVal);
                    GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, this.configOption, doubleVal));
                    break;
                }
                case FLOAT: {
                    float floatVal = (float)(value * (this.max - this.min) + this.min);
                    this.func_238482_a_((ITextComponent)new StringTextComponent(Float.toString(floatVal)));
                    this.config.setValue(this.configOption, Float.valueOf(floatVal));
                    GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, this.configOption, Float.valueOf(floatVal)));
                    break;
                }
                case INT: {
                    int intVal = (int)(value * (this.max - this.min) + this.min);
                    this.func_238482_a_((ITextComponent)new StringTextComponent(Integer.toString(intVal)));
                    this.config.setValue(this.configOption, intVal);
                    GuiModOptions.this.handler.onConfigChanging(new ConfigChangedEvent.OnConfigChangingEvent(GuiModOptions.this.modName, this.configOption, intVal));
                }
            }
        }

        protected void func_230441_a_(MatrixStack stack, Minecraft mc, int mouseX, int mouseY) {
            if (this.field_230694_p_) {
                if (this.dragging) {
                    this.sliderValue = (float)(mouseX - (this.field_230690_l_ + 4)) / (float)(this.field_230688_j_ - 8);
                    this.sliderValue = MathHelper.func_151237_a((double)this.sliderValue, (double)0.0, (double)1.0);
                    this.updateValue(this.sliderValue);
                    if (GuiModOptions.this.mouseReleased) {
                        this.dragging = false;
                        GuiModOptions.this.mouseReleased = false;
                    }
                }
                mc.func_110434_K().func_110577_a(field_230687_i_);
                GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_238474_b_(stack, this.field_230690_l_ + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, 66, 4, 20);
                this.func_238474_b_(stack, this.field_230690_l_ + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)) + 4, this.field_230691_m_, 196, 66, 4, 20);
            }
        }

        public final void func_230982_a_(double mouseX, double mouseY) {
            this.sliderValue = (mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8);
            this.sliderValue = MathHelper.func_151237_a((double)this.sliderValue, (double)0.0, (double)1.0);
            this.updateValue(this.sliderValue);
            this.dragging = true;
            GuiModOptions.this.mouseReleased = false;
        }

        public void func_231000_a__(double mouseX, double mouseY) {
            this.dragging = false;
        }

        public void func_230995_c_(boolean b) {
            Object value = this.config.getValue(this.configOption);
            if (value instanceof Double) {
                this.func_238482_a_((ITextComponent)new StringTextComponent(Double.toString((Double)value)));
                this.sliderValue = ((Double)value - this.min) / (this.max - this.min);
            } else if (value instanceof Float) {
                this.func_238482_a_((ITextComponent)new StringTextComponent(Float.toString(((Float)value).floatValue())));
                this.sliderValue = ((double)((Float)value).floatValue() - this.min) / (this.max - this.min);
            } else {
                this.func_238482_a_((ITextComponent)new StringTextComponent(Integer.toString((Integer)value)));
                this.sliderValue = ((double)((Integer)value).intValue() - this.min) / (this.max - this.min);
            }
            super.func_230995_c_(b);
        }
    }

    private static enum Type {
        INT,
        FLOAT,
        DOUBLE;

    }
}

