/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost;

import WolfShotz.Wyrmroost.WRConfig;
import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.client.screen.DebugScreen;
import WolfShotz.Wyrmroost.data.DataGatherer;
import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.entities.util.VillagerHelper;
import WolfShotz.Wyrmroost.items.base.ArmorBase;
import WolfShotz.Wyrmroost.registry.WRWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CommonEvents {
    public static final List<Runnable> CALLBACKS = new ArrayList<Runnable>();

    public static void load() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        bus.addListener(CommonEvents::commonSetup);
        bus.addListener(WRConfig::configLoad);
        bus.addListener(DataGatherer::gather);
        forgeBus.addListener(CommonEvents::debugStick);
        forgeBus.addListener(CommonEvents::onChangeEquipment);
        forgeBus.addListener(VillagerHelper::addWandererTrades);
        forgeBus.addListener(EventPriority.HIGH, WRWorld::onBiomeLoad);
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CALLBACKS.forEach(Runnable::run);
            CALLBACKS.clear();
        });
    }

    public static void debugStick(PlayerInteractEvent.EntityInteract evt) {
        if (!WRConfig.debugMode) {
            return;
        }
        PlayerEntity player = evt.getPlayer();
        ItemStack stack = player.func_184586_b(evt.getHand());
        if (stack.func_77973_b() != Items.field_151055_y || !stack.func_200301_q().func_150261_e().equals("Debug Stick")) {
            return;
        }
        evt.setCanceled(true);
        evt.setCancellationResult(ActionResultType.SUCCESS);
        Entity entity = evt.getTarget();
        entity.func_213323_x_();
        if (!(entity instanceof AbstractDragonEntity)) {
            return;
        }
        AbstractDragonEntity dragon = (AbstractDragonEntity)entity;
        if (player.func_225608_bj_()) {
            dragon.tame(true, player);
        } else if (dragon.field_70170_p.field_72995_K) {
            DebugScreen.open(dragon);
        } else {
            Wyrmroost.LOG.info(dragon.func_70661_as().func_75505_d() == null ? "null" : dragon.func_70661_as().func_75505_d().func_224770_k().toString());
        }
    }

    @SubscribeEvent
    public static void onChangeEquipment(LivingEquipmentChangeEvent evt) {
        ArmorBase initial;
        if (evt.getTo().func_77973_b() instanceof ArmorBase) {
            initial = (ArmorBase)evt.getTo().func_77973_b();
        } else if (evt.getFrom().func_77973_b() instanceof ArmorBase) {
            initial = (ArmorBase)evt.getFrom().func_77973_b();
        } else {
            return;
        }
        LivingEntity entity = evt.getEntityLiving();
        initial.applyFullSetBonus(entity, ArmorBase.hasFullSet(entity));
    }
}

