/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost;

import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class WRConfig {
    public static boolean debugMode = false;
    public static boolean disableFrustumCheck = true;
    public static double fireBreathFlammability = 0.8;
    public static int homeRadius = 16;
    public static double dfdBabyChance = 0.4;
    private static boolean respectMobGriefing;
    private static boolean dragonGriefing;

    public static boolean canGrief(World world) {
        return respectMobGriefing ? world.func_82736_K().func_223586_b(GameRules.field_223599_b) : dragonGriefing;
    }

    public static void configLoad(ModConfig.ModConfigEvent evt) {
        ForgeConfigSpec spec = evt.getConfig().getSpec();
        if (spec == Common.SPEC) {
            Common.reload();
        } else if (spec == Client.SPEC) {
            Client.reload();
        } else if (spec == Server.SPEC) {
            Server.reload();
        }
    }

    public static class Server {
        public static final Server INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public final ForgeConfigSpec.IntValue homeRadius;
        public final ForgeConfigSpec.DoubleValue dfdBabyChance;
        public final ForgeConfigSpec.DoubleValue breathFlammability;
        public final ForgeConfigSpec.BooleanValue respectMobGriefing;
        public final ForgeConfigSpec.BooleanValue dragonGriefing;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Wyrmroost Dragon Options").push("dragons");
            this.homeRadius = builder.comment("How far dragons can travel from their home points").translation("config.wyrmroost.homeradius").defineInRange("homeRadius", 16, 6, 1024);
            this.dfdBabyChance = builder.comment("Chances for a Dragon Fruit Drake to spawn as a baby. 0 = No Chance, 1 = (practically) Guaranteed. Higher values are better chances").translation("config.wyrmroost.dfdbabychance").defineInRange("dfdBabyChance", 0.3, 0.0, 1.0);
            this.breathFlammability = builder.comment("Base Flammability for Dragon Fire Breath. A value of 0 will disable fire block damage completely.").translation("config.wyrmroost.breathFlammability").defineInRange("breathFlammability", 0.8, 0.0, 1.0);
            builder.push("griefing");
            this.respectMobGriefing = builder.comment("If True, Dragons will respect the Minecraft MobGriefing Gamerule. Else, follow \"dragonGriefing\" option").translation("config.wyrmroost.respectMobGriefing").define("respectMobGriefing", true);
            this.dragonGriefing = builder.comment("If true and not respecting MobGriefing rules, allow dragons to grief").translation("config.wyrmroost.dragonGriefing").define("dragonGriefing", true);
            builder.pop();
            builder.pop();
        }

        public static void reload() {
            homeRadius = (Integer)Server.INSTANCE.homeRadius.get();
            dfdBabyChance = (Double)Server.INSTANCE.dfdBabyChance.get();
            fireBreathFlammability = (Double)Server.INSTANCE.breathFlammability.get();
            respectMobGriefing = (Boolean)Server.INSTANCE.respectMobGriefing.get();
            dragonGriefing = (Boolean)Server.INSTANCE.dragonGriefing.get();
        }

        static {
            Pair pair = new ForgeConfigSpec.Builder().configure(Server::new);
            INSTANCE = (Server)pair.getLeft();
            SPEC = (ForgeConfigSpec)pair.getRight();
        }
    }

    public static class Client {
        public static final Client INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public final ForgeConfigSpec.BooleanValue disableFrustumCheck;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Wyrmroost Client Options").push("General");
            this.disableFrustumCheck = builder.comment("Disables Frustum check when rendering (Dragons parts dont go poof when looking too far) - Only applies to bigger bois").translation("config.wyrmroost.disableFrustumCheck").define("disableFrustumCheck", true);
            builder.pop();
        }

        public static void reload() {
            disableFrustumCheck = (Boolean)Client.INSTANCE.disableFrustumCheck.get();
        }

        static {
            Pair pair = new ForgeConfigSpec.Builder().configure(Client::new);
            INSTANCE = (Client)pair.getLeft();
            SPEC = (ForgeConfigSpec)pair.getRight();
        }
    }

    public static class Common {
        public static final Common INSTANCE;
        public static final ForgeConfigSpec SPEC;
        public final ForgeConfigSpec.BooleanValue debugMode;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Wyrmroost General Options").push("general");
            this.debugMode = builder.comment("Do not enable this unless you are told to!").translation("config.wyrmroost.debug").define("debugMode", false);
            builder.pop();
        }

        public static void reload() {
            debugMode = (Boolean)Common.INSTANCE.debugMode.get();
        }

        static {
            Pair pair = new ForgeConfigSpec.Builder().configure(Common::new);
            INSTANCE = (Common)pair.getLeft();
            SPEC = (ForgeConfigSpec)pair.getRight();
        }
    }
}

