/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.client.model;

import WolfShotz.Wyrmroost.client.model.BoxPosCache;
import WolfShotz.Wyrmroost.client.model.WRModelRenderer;
import WolfShotz.Wyrmroost.entities.util.animation.Animation;
import WolfShotz.Wyrmroost.entities.util.animation.IAnimatedEntity;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;

public class ModelAnimator {
    private int tempTick = 0;
    private int prevTempTick;
    private boolean correctAnimation = false;
    private float partialTicks;
    private IAnimatedEntity entity;
    private final HashMap<WRModelRenderer, BoxPosCache> boxPosCache = new HashMap();
    private final HashMap<WRModelRenderer, BoxPosCache> prevPosCache = new HashMap();

    private ModelAnimator() {
    }

    public static ModelAnimator create() {
        return new ModelAnimator();
    }

    public IAnimatedEntity getEntity() {
        return this.entity;
    }

    public void update(IAnimatedEntity entity, float partialTicks) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnimation = false;
        this.entity = entity;
        this.partialTicks = partialTicks;
        this.boxPosCache.clear();
        this.prevPosCache.clear();
    }

    public boolean setAnimation(Animation animation) {
        this.prevTempTick = 0;
        this.tempTick = 0;
        this.correctAnimation = this.entity.getAnimation() == animation;
        return this.correctAnimation;
    }

    public void startKeyframe(int duration) {
        if (this.correctAnimation) {
            this.prevTempTick = this.tempTick;
            this.tempTick += duration;
        }
    }

    public void setStaticKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe(true);
    }

    public void resetKeyframe(int duration) {
        this.startKeyframe(duration);
        this.endKeyframe();
    }

    public void rotate(WRModelRenderer box, float x, float y, float z) {
        if (this.correctAnimation) {
            this.getPosCache(box).addRotation(x, y, z);
        }
    }

    public void move(WRModelRenderer box, float x, float y, float z) {
        if (this.correctAnimation) {
            this.getPosCache(box).addOffset(x, y, z);
        }
    }

    private BoxPosCache getPosCache(WRModelRenderer box) {
        return this.boxPosCache.computeIfAbsent(box, b -> new BoxPosCache());
    }

    public void endKeyframe() {
        this.endKeyframe(false);
    }

    private void endKeyframe(boolean stationary) {
        if (this.correctAnimation) {
            int animationTick = this.entity.getAnimationTick();
            if (animationTick >= this.prevTempTick && animationTick < this.tempTick) {
                if (stationary) {
                    for (Map.Entry<WRModelRenderer, BoxPosCache> entry : this.prevPosCache.entrySet()) {
                        ModelRenderer box = entry.getKey();
                        BoxPosCache cache = entry.getValue();
                        box.field_78795_f += cache.getRotationX();
                        box.field_78796_g += cache.getRotationY();
                        box.field_78808_h += cache.getRotationZ();
                        box.field_78800_c += cache.getOffsetX();
                        box.field_78797_d += cache.getOffsetY();
                        box.field_78798_e += cache.getOffsetZ();
                    }
                } else {
                    BoxPosCache cache;
                    ModelRenderer box;
                    float tick = ((float)(animationTick - this.prevTempTick) + this.partialTicks) / (float)(this.tempTick - this.prevTempTick);
                    float inc = MathHelper.func_76126_a((float)(tick * (float)Math.PI / 2.0f));
                    float dec = 1.0f - inc;
                    for (Map.Entry<WRModelRenderer, BoxPosCache> entry : this.prevPosCache.entrySet()) {
                        box = entry.getKey();
                        cache = entry.getValue();
                        box.field_78795_f += dec * cache.getRotationX();
                        box.field_78796_g += dec * cache.getRotationY();
                        box.field_78808_h += dec * cache.getRotationZ();
                        box.field_78800_c += dec * cache.getOffsetX();
                        box.field_78797_d += dec * cache.getOffsetY();
                        box.field_78798_e += dec * cache.getOffsetZ();
                    }
                    for (Map.Entry<WRModelRenderer, BoxPosCache> entry : this.boxPosCache.entrySet()) {
                        box = entry.getKey();
                        cache = entry.getValue();
                        box.field_78795_f += inc * cache.getRotationX();
                        box.field_78796_g += inc * cache.getRotationY();
                        box.field_78808_h += inc * cache.getRotationZ();
                        box.field_78800_c += inc * cache.getOffsetX();
                        box.field_78797_d += inc * cache.getOffsetY();
                        box.field_78798_e += inc * cache.getOffsetZ();
                    }
                }
            }
            if (!stationary) {
                this.prevPosCache.clear();
                this.prevPosCache.putAll(this.boxPosCache);
                this.boxPosCache.clear();
            }
        }
    }
}

