/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.client.model;

import WolfShotz.Wyrmroost.client.model.WRModelRenderer;
import WolfShotz.Wyrmroost.util.Mafs;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public abstract class WREntityModel<T extends Entity>
extends EntityModel<T> {
    public T entity;
    public float globalSpeed = 0.5f;
    public final List<ModelRenderer> boxList = Lists.newArrayList();
    public float time;

    public WREntityModel() {
    }

    public WREntityModel(Function<ResourceLocation, RenderType> type) {
        super(type);
    }

    public void setDefaultPose() {
        for (ModelRenderer box : this.boxList) {
            if (!(box instanceof WRModelRenderer)) continue;
            ((WRModelRenderer)box).setDefaultPose();
        }
    }

    public void resetToDefaultPose() {
        this.globalSpeed = 0.5f;
        for (ModelRenderer box : this.boxList) {
            if (!(box instanceof WRModelRenderer)) continue;
            ((WRModelRenderer)box).resetToDefaultPose();
        }
    }

    public void setRotateAngle(ModelRenderer model, float x, float y, float z) {
        model.field_78795_f = x;
        model.field_78796_g = y;
        model.field_78808_h = z;
    }

    public void faceTarget(float yaw, float pitch, float rotationDivisor, ModelRenderer ... boxes) {
        yaw = (float)Math.toRadians(yaw) / (rotationDivisor *= (float)boxes.length);
        pitch = (float)Math.toRadians(pitch) / rotationDivisor;
        for (ModelRenderer box : boxes) {
            box.field_78795_f += pitch;
            box.field_78796_g += yaw;
        }
    }

    public void walk(WRModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        box.walk(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(WRModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        box.flap(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(WRModelRenderer box, float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        box.swing(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(WRModelRenderer box, float speed, float degree, boolean bounce, float limbSwing, float limbSwingAmount) {
        box.bob(speed, degree, bounce, limbSwing, limbSwingAmount);
    }

    public void chainWave(ModelRenderer[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78795_f += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainSwing(ModelRenderer[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78796_g += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    public void chainFlap(ModelRenderer[] boxes, float speed, float degree, double rootOffset, float swing, float swingAmount) {
        float offset = this.calculateChainOffset(rootOffset, boxes);
        for (int index = 0; index < boxes.length; ++index) {
            boxes[index].field_78808_h += this.calculateChainRotation(speed, degree, swing, swingAmount, offset, index);
        }
    }

    private float calculateChainRotation(float speed, float degree, float swing, float swingAmount, float offset, int boxIndex) {
        return MathHelper.func_76134_b((float)(swing * speed + offset * (float)boxIndex)) * swingAmount * degree;
    }

    private float calculateChainOffset(double rootOffset, ModelRenderer ... boxes) {
        return (float)rootOffset * (float)Math.PI / (2.0f * (float)boxes.length);
    }

    public void setTime(float x) {
        this.time = x;
    }

    public void toDefaultPose() {
        for (ModelRenderer modelRenderer : this.boxList) {
            if (!(modelRenderer instanceof WRModelRenderer)) continue;
            WRModelRenderer box = (WRModelRenderer)modelRenderer;
            box.field_78800_c = Mafs.linTerp(box.field_78800_c, box.defaultPositionX, this.time);
            box.field_78797_d = Mafs.linTerp(box.field_78797_d, box.defaultPositionY, this.time);
            box.field_78798_e = Mafs.linTerp(box.field_78798_e, box.defaultPositionZ, this.time);
            box.field_78795_f = Mafs.linTerp(box.field_78795_f, box.defaultRotationX, this.time);
            box.field_78796_g = Mafs.linTerp(box.field_78796_g, box.defaultRotationY, this.time);
            box.field_78808_h = Mafs.linTerp(box.field_78808_h, box.defaultRotationZ, this.time);
        }
    }

    public void move(ModelRenderer box, float x, float y, float z) {
        box.field_78800_c += this.time * x;
        box.field_78797_d += this.time * y;
        box.field_78798_e += this.time * z;
    }

    public void rotate(ModelRenderer box, float x, float y, float z) {
        box.field_78795_f += this.time * x;
        box.field_78796_g += this.time * y;
        box.field_78808_h += this.time * z;
    }

    public void idle(float frame) {
    }
}

