/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.client.render;

import WolfShotz.Wyrmroost.WRConfig;
import WolfShotz.Wyrmroost.client.ClientEvents;
import WolfShotz.Wyrmroost.entities.dragon.AbstractDragonEntity;
import WolfShotz.Wyrmroost.items.staff.DragonStaffItem;
import WolfShotz.Wyrmroost.registry.WRItems;
import WolfShotz.Wyrmroost.util.ModUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.OutlineLayerBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;

public class RenderHelper
extends RenderType {
    private static final Object2IntMap<Entity> ENTITY_OUTLINE_MAP = new Object2IntOpenHashMap(1);

    private RenderHelper() {
        super(null, null, 0, 0, false, false, null, null);
    }

    public static RenderType getAdditiveGlow(ResourceLocation locationIn) {
        return RenderHelper.func_228633_a_((String)"glow", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228726_a_(field_228511_c_).func_228713_a_(field_228517_i_).func_228728_a_(false));
    }

    public static RenderType getTranslucentGlow(ResourceLocation texture) {
        return RenderHelper.func_228633_a_((String)"glow", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)false, (boolean)true, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(texture, false, false)).func_228714_a_(field_228491_A_).func_228726_a_(field_228515_g_).func_228713_a_(field_228517_i_).func_228728_a_(false));
    }

    public static RenderType getThiccLines(double thickness) {
        return RenderHelper.func_228632_a_((String)"thickened_lines", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(thickness))).func_228726_a_(field_228515_g_).func_228727_a_(field_228496_F_).func_228728_a_(false));
    }

    public static void renderWorld(RenderWorldLastEvent evt) {
        MatrixStack ms = evt.getMatrixStack();
        float partialTicks = evt.getPartialTicks();
        RenderHelper.renderDragonStaff(ms, partialTicks);
        DebugBox.INSTANCE.render(ms);
    }

    public static void renderEntityOutline(Entity entity, int red, int green, int blue, int alpha) {
        ENTITY_OUTLINE_MAP.put((Object)entity, (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF);
    }

    public static void renderEntities(RenderLivingEvent.Pre<? super LivingEntity, ?> event) {
        LivingEntity entity = event.getEntity();
        int color = ENTITY_OUTLINE_MAP.removeInt((Object)entity);
        if (color != 0) {
            event.setCanceled(true);
            Minecraft mc = ClientEvents.getClient();
            OutlineLayerBuffer buffer = mc.func_228019_au_().func_228490_d_();
            MatrixStack ms = event.getMatrixStack();
            LivingRenderer renderer = event.getRenderer();
            float partialTicks = event.getPartialRenderTick();
            float yaw = MathHelper.func_219799_g((float)partialTicks, (float)entity.field_70126_B, (float)entity.field_70177_z);
            buffer.func_228472_a_(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF);
            renderer.func_225623_a_(entity, yaw, partialTicks, ms, (IRenderTypeBuffer)buffer, 0xF00000);
            buffer.func_228471_a_();
        }
    }

    private static void renderDragonStaff(MatrixStack ms, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ItemStack stack = ModUtils.getHeldStack((PlayerEntity)player, (Item)WRItems.DRAGON_STAFF.get());
        if (stack == null) {
            return;
        }
        AbstractDragonEntity dragon = DragonStaffItem.getBoundDragon((World)mc.field_71441_e, stack);
        if (dragon == null) {
            return;
        }
        DragonStaffItem.getAction(stack).render(dragon, ms, partialTicks);
        RenderHelper.renderEntityOutline((Entity)dragon, 0, 255, 255, (int)(MathHelper.func_76134_b((float)(((float)dragon.field_70173_aa + partialTicks) * 0.2f)) * 35.0f + 45.0f));
        LivingEntity target = dragon.func_70638_az();
        if (target != null) {
            RenderHelper.renderEntityOutline((Entity)target, 255, 0, 0, 100);
        }
        dragon.getHomePos().ifPresent(pos -> RenderHelper.drawBlockPos(ms, pos, dragon.field_70170_p, 4.0, -16776961));
    }

    public static void drawShape(MatrixStack ms, IVertexBuilder buffer, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = ms.func_227866_c_().func_227870_a_();
        shapeIn.func_197754_a((x1, y1, z1, x2, y2, z2) -> {
            buffer.func_227888_a_(matrix4f, (float)(x1 + xIn), (float)(y1 + yIn), (float)(z1 + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
            buffer.func_227888_a_(matrix4f, (float)(x2 + xIn), (float)(y2 + yIn), (float)(z2 + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
        });
    }

    public static void drawBlockPos(MatrixStack ms, BlockPos pos, World world, double lineThickness, int argb) {
        Vector3d view = ClientEvents.getProjectedView();
        double x = (double)pos.func_177958_n() - view.field_72450_a;
        double y = (double)pos.func_177956_o() - view.field_72448_b;
        double z = (double)pos.func_177952_p() - view.field_72449_c;
        IRenderTypeBuffer.Impl impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderHelper.drawShape(ms, impl.getBuffer(RenderHelper.getThiccLines(lineThickness)), world.func_180495_p(pos).func_196954_c((IBlockReader)world, pos), x, y, z, (float)(argb >> 16 & 0xFF) / 255.0f, (float)(argb >> 8 & 0xFF) / 255.0f, (float)(argb & 0xFF) / 255.0f, (float)(argb >> 24 & 0xFF) / 255.0f);
        impl.func_228461_a_();
    }

    public static enum DebugBox {
        INSTANCE;

        private int time = 0;
        private AxisAlignedBB aabb = null;
        private int color = -16776961;

        public void queue(AxisAlignedBB aabb) {
            this.aabb = aabb;
            this.time = Integer.MAX_VALUE;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public void reset() {
            this.aabb = null;
            this.time = 0;
            this.color = -16776961;
        }

        public void render(MatrixStack ms) {
            if (!WRConfig.debugMode) {
                return;
            }
            if (this.aabb == null) {
                return;
            }
            Vector3d view = ClientEvents.getProjectedView();
            double x = view.field_72450_a;
            double y = view.field_72448_b;
            double z = view.field_72449_c;
            IRenderTypeBuffer.Impl type = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            WorldRenderer.func_228427_a_((MatrixStack)ms, (IVertexBuilder)type.getBuffer(RenderType.func_228659_m_()), (double)(this.aabb.field_72340_a - x), (double)(this.aabb.field_72338_b - y), (double)(this.aabb.field_72339_c - z), (double)(this.aabb.field_72336_d - x), (double)(this.aabb.field_72337_e - y), (double)(this.aabb.field_72334_f - z), (float)((float)(this.color & 0xFF) / 255.0f), (float)((float)(this.color >> 8 & 0xFF) / 255.0f), (float)((float)(this.color >> 16 & 0xFF) / 255.0f), (float)((float)(this.color >> 24 & 0xFF) / 255.0f));
            type.func_228461_a_();
            if (--this.time <= 0) {
                this.aabb = null;
            }
        }
    }
}

