/*
 * Decompiled with CFR 0.152.
 */
package WolfShotz.Wyrmroost.client.render.entity.owdrake;

import WolfShotz.Wyrmroost.Wyrmroost;
import WolfShotz.Wyrmroost.client.render.entity.AbstractDragonRenderer;
import WolfShotz.Wyrmroost.client.render.entity.owdrake.OWDrakeModel;
import WolfShotz.Wyrmroost.entities.dragon.OWDrakeEntity;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;

public class OWDrakeRenderer
extends AbstractDragonRenderer<OWDrakeEntity, OWDrakeModel> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[64];
    public static final ResourceLocation DAISY = OWDrakeRenderer.resource("daisy.png");
    public static final ResourceLocation JEB_ = OWDrakeRenderer.resource("jeb.png");
    public static final ResourceLocation SADDLE_LAYER = OWDrakeRenderer.resource("accessories/saddle.png");

    public OWDrakeRenderer(EntityRendererManager manager) {
        super(manager, new OWDrakeModel(), 1.6f);
        this.func_177094_a(new AbstractDragonRenderer.ArmorLayer(1));
        this.func_177094_a(new AbstractDragonRenderer.ConditionalLayer(OWDrakeEntity::isSaddled, d -> RenderType.func_228640_c_((ResourceLocation)SADDLE_LAYER)));
    }

    public static ResourceLocation resource(String png) {
        return Wyrmroost.rl("textures/entity/dragon/overworld_drake/" + png);
    }

    @Nullable
    public ResourceLocation getEntityTexture(OWDrakeEntity drake) {
        if (drake.func_145818_k_()) {
            String name = drake.func_200201_e().func_150261_e();
            if (name.equals("Daisy")) {
                return DAISY;
            }
            if (name.equalsIgnoreCase("Jeb_")) {
                return JEB_;
            }
        }
        int index = 0;
        if (drake.func_70631_g_()) {
            index |= 1;
        } else if (!drake.isMale()) {
            index |= 2;
        }
        if (drake.getVariant() == -1) {
            index |= 4;
        } else if (drake.getVariant() == 1) {
            index |= 8;
        }
        if (TEXTURES[index] == null) {
            String path;
            String string = (index & 1) != 0 ? "child" : (path = (index & 2) != 0 ? "female" : "male");
            if ((index & 4) != 0) {
                path = path + "_spe";
            } else if ((index & 8) != 0) {
                path = path + "_sav";
            }
            OWDrakeRenderer.TEXTURES[index] = OWDrakeRenderer.resource(path + ".png");
            return OWDrakeRenderer.TEXTURES[index];
        }
        return TEXTURES[index];
    }
}

